/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import paper.libs.org.eclipse.core.expressions.EvaluationResult;
import paper.libs.org.eclipse.core.expressions.Expression;
import paper.libs.org.eclipse.core.expressions.ExpressionInfo;
import paper.libs.org.eclipse.core.expressions.IEvaluationContext;
import paper.libs.org.eclipse.core.runtime.CoreException;

public abstract class CompositeExpression
extends Expression {
    private static final Expression[] EMPTY_ARRAY = new Expression[0];
    private static final int HASH_INITIAL = CompositeExpression.class.getName().hashCode();
    protected List<Expression> fExpressions;

    public void add(Expression expression) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList<Expression>(2);
        }
        this.fExpressions.add(expression);
    }

    public Expression[] getChildren() {
        if (this.fExpressions == null) {
            return EMPTY_ARRAY;
        }
        return this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    protected EvaluationResult evaluateAnd(IEvaluationContext scope) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult result = EvaluationResult.TRUE;
        for (Expression expression : this.fExpressions) {
            if ((result = result.and(expression.evaluate(scope))) != EvaluationResult.FALSE) continue;
            return result;
        }
        return result;
    }

    protected EvaluationResult evaluateOr(IEvaluationContext scope) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult result = EvaluationResult.FALSE;
        for (Expression expression : this.fExpressions) {
            if ((result = result.or(expression.evaluate(scope))) != EvaluationResult.TRUE) continue;
            return result;
        }
        return result;
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        if (this.fExpressions == null) {
            return;
        }
        for (Expression expression : this.fExpressions) {
            expression.collectExpressionInfo(info);
        }
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + CompositeExpression.hashCode(this.fExpressions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        Object[] children = this.getChildren();
        if (children.length > 0) {
            builder.append(" [children=");
            builder.append(Arrays.toString(children));
            builder.append("]");
        }
        return builder.toString();
    }
}

