/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.List;
import paper.libs.org.eclipse.core.commands.ExecutionException;
import paper.libs.org.eclipse.core.commands.operations.IUndoContext;
import paper.libs.org.eclipse.core.commands.operations.IUndoableOperation;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.IAdaptable;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;

public abstract class AbstractOperation
implements IUndoableOperation {
    List<IUndoContext> contexts = new ArrayList<IUndoContext>();
    private String label = "";

    public AbstractOperation(String label) {
        Assert.isNotNull(label);
        this.label = label;
    }

    @Override
    public void addContext(IUndoContext context) {
        if (!this.contexts.contains(context)) {
            this.contexts.add(context);
        }
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public abstract IStatus execute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public final IUndoContext[] getContexts() {
        return this.contexts.toArray(new IUndoContext[this.contexts.size()]);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String name2) {
        this.label = name2;
    }

    @Override
    public final boolean hasContext(IUndoContext context) {
        Assert.isNotNull(context);
        for (IUndoContext otherContext : this.contexts) {
            if (!context.matches(otherContext) && !otherContext.matches(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract IStatus redo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public void removeContext(IUndoContext context) {
        this.contexts.remove(context);
    }

    @Override
    public abstract IStatus undo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.getLabel());
        stringBuffer.append("(");
        IUndoContext[] contexts = this.getContexts();
        int i2 = 0;
        while (i2 < contexts.length) {
            stringBuffer.append(contexts[i2].toString());
            if (i2 != contexts.length - 1) {
                stringBuffer.append(',');
            }
            ++i2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

