/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury.jdt.internal.rewrite.imports;

import java.util.Comparator;
import paper.libs.org.cadixdev.mercury.jdt.internal.rewrite.imports.ImportName;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;

final class PackageImportComparator
implements Comparator<ImportName> {
    private final JavaProject javaProject;

    PackageImportComparator(JavaProject javaProject) {
        this.javaProject = javaProject;
    }

    @Override
    public int compare(ImportName o1, ImportName o2) {
        return this.determinePackageName(o1).compareTo(this.determinePackageName(o2));
    }

    private String determinePackageName(ImportName importName) {
        String containerName = importName.containerName;
        try {
            String containerNamePrefix = containerName;
            while (true) {
                if (this.javaProject.findPackageFragment(containerNamePrefix) != null) {
                    return containerNamePrefix;
                }
                int lastSegmentStart = containerNamePrefix.lastIndexOf(46) + 1;
                if (this.javaProject.findType(containerNamePrefix) == null && Character.isLowerCase(containerNamePrefix.charAt(lastSegmentStart))) {
                    return containerNamePrefix;
                }
                if (lastSegmentStart != 0) {
                    containerNamePrefix = containerNamePrefix.substring(0, lastSegmentStart - 1);
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return containerName;
    }
}

