/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import paper.libs.org.cadixdev.mercury.RewriteContext;
import paper.libs.org.cadixdev.mercury.SourceContext;
import paper.libs.org.cadixdev.mercury.SourceProcessor;
import paper.libs.org.eclipse.jdt.core.JavaCore;
import paper.libs.org.eclipse.jdt.core.dom.AST;
import paper.libs.org.eclipse.jdt.core.dom.ASTParser;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.core.dom.FileASTRequestor;
import paper.libs.org.eclipse.jdt.core.dom.IBinding;
import paper.libs.org.eclipse.jdt.core.dom.ITypeBinding;

public final class Mercury {
    public static final String JAVA_EXTENSION = ".java";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String sourceCompatibility = "1.8";
    private Charset encoding = StandardCharsets.UTF_8;
    private boolean gracefulClasspathChecks = false;
    private boolean gracefulJavadocClasspathChecks = false;
    private boolean flexibleAnonymousClassMemberLookups = false;
    private final List<Path> classPath = new ArrayList<Path>();
    private final List<Path> sourcePath = new ArrayList<Path>();
    private final Map<Object, Object> context = new HashMap<Object, Object>();
    private Path sourceDir;
    private Path outputDir;
    private final List<SourceProcessor> processors = new ArrayList<SourceProcessor>();
    private final FileASTRequestor requestor = new Requestor();

    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public void setSourceCompatibility(String sourceCompatibility) {
        this.sourceCompatibility = Objects.requireNonNull(sourceCompatibility, "sourceCompatibility");
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = Objects.requireNonNull(encoding, "encoding");
    }

    public boolean isGracefulClasspathChecks() {
        return this.gracefulClasspathChecks;
    }

    public void setGracefulClasspathChecks(boolean enable) {
        this.gracefulClasspathChecks = enable;
    }

    public boolean isGracefulJavadocClasspathChecks() {
        return this.gracefulJavadocClasspathChecks;
    }

    public void setGracefulJavadocClasspathChecks(boolean enable) {
        this.gracefulJavadocClasspathChecks = enable;
    }

    public boolean isFlexibleAnonymousClassMemberLookups() {
        return this.flexibleAnonymousClassMemberLookups;
    }

    public void setFlexibleAnonymousClassMemberLookups(boolean enable) {
        this.flexibleAnonymousClassMemberLookups = enable;
    }

    public List<Path> getClassPath() {
        return this.classPath;
    }

    public List<Path> getSourcePath() {
        return this.sourcePath;
    }

    public List<SourceProcessor> getProcessors() {
        return this.processors;
    }

    public Path getSourceDir() {
        return this.sourceDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public Map<Object, Object> getContext() {
        return this.context;
    }

    public Optional<ITypeBinding> createTypeBinding(String className) {
        if (Mercury.isAnonymousOrLocalType(className)) {
            return Optional.empty();
        }
        IBinding binding = this.requestor.createBindings(new String[]{'L' + className.replace('.', '/') + ';'})[0];
        return binding != null && binding.getKind() == 2 ? Optional.of((ITypeBinding)binding) : Optional.empty();
    }

    private static boolean isAnonymousOrLocalType(String className) {
        int i2 = className.indexOf(36) + 1;
        while (i2 > 0 && i2 < className.length()) {
            if (Character.isDigit(className.charAt(i2))) {
                return true;
            }
            i2 = className.indexOf(36, i2) + 1;
        }
        return false;
    }

    public void process(Path sourceDir) throws Exception {
        if (this.sourceDir != null) {
            throw new IllegalStateException("Instance is currently processing: " + this.sourceDir);
        }
        try {
            this.sourceDir = Objects.requireNonNull(sourceDir, "sourceDir");
            this.run();
        }
        finally {
            this.cleanup();
        }
    }

    public void rewrite(Path sourceDir, Path outputDir) throws Exception {
        if (this.sourceDir != null) {
            throw new IllegalStateException("Instance is currently processing: " + this.sourceDir);
        }
        try {
            this.sourceDir = Objects.requireNonNull(sourceDir, "sourceDir");
            this.outputDir = Objects.requireNonNull(outputDir, "outputDir");
            this.run();
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.sourceDir = null;
        this.outputDir = null;
        this.context.clear();
    }

    private void run() throws Exception {
        ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
        Hashtable<String, String> options = JavaCore.getOptions();
        JavaCore.setComplianceOptions(this.sourceCompatibility, options);
        parser.setCompilerOptions(options);
        int flags = 0;
        for (SourceProcessor processor : this.processors) {
            flags |= processor.getFlags();
        }
        if (flags & true) {
            parser.setResolveBindings(true);
            parser.setBindingsRecovery(true);
        }
        String[] sourcePath = Mercury.toArray(this.sourcePath.stream());
        parser.setEnvironment(Mercury.toArray(this.classPath.stream()), sourcePath, this.getEncodings(sourcePath), true);
        String[] sourceFiles = Mercury.toArray(Files.walk(this.sourceDir, FileVisitOption.FOLLOW_LINKS).filter(p -> p.getFileName() != null && p.getFileName().toString().endsWith(JAVA_EXTENSION)));
        for (SourceProcessor processor : this.processors) {
            processor.initialize(this);
        }
        parser.createASTs(sourceFiles, this.getEncodings(sourceFiles), EMPTY_STRING_ARRAY, this.requestor, null);
        for (SourceProcessor processor : this.processors) {
            processor.finish(this);
        }
    }

    private SourceContext createContext(String sourceFilePath, CompilationUnit ast) {
        Path sourceFile = Paths.get(sourceFilePath, new String[0]);
        String fileName = sourceFile.getFileName().toString();
        String primaryType = fileName.substring(0, fileName.length() - JAVA_EXTENSION.length());
        if (this.outputDir != null) {
            return new RewriteContext(this, sourceFile, ast, primaryType);
        }
        return new SourceContext(this, sourceFile, ast, primaryType);
    }

    void accept(String sourceFilePath, CompilationUnit ast) {
        SourceContext context = this.createContext(sourceFilePath, ast);
        try {
            context.process(this.processors);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process: " + sourceFilePath, e);
        }
    }

    private static String[] toArray(Stream<Path> stream) {
        return (String[])stream.map(Path::toString).toArray(String[]::new);
    }

    private String[] getEncodings(String[] files) {
        if (files.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        Object[] encodings = new String[files.length];
        Arrays.fill(encodings, this.encoding.name());
        return encodings;
    }

    private class Requestor
    extends FileASTRequestor {
        private Requestor() {
        }

        @Override
        public void acceptAST(String sourceFilePath, CompilationUnit ast) {
            Mercury.this.accept(sourceFilePath, ast);
        }
    }
}

