/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;

class SystemClassProviderRootJdk8
implements ClassProviderRoot {
    @NotNull
    private final ClassProviderRoot delegate;

    SystemClassProviderRootJdk8() throws IOException {
        Class<String> clazz = String.class;
        String classFileName = '/' + clazz.getName().replace('.', '/') + ".class";
        URL classFileUrl = clazz.getResource(classFileName);
        if (classFileUrl == null) {
            throw new IllegalStateException("Could not find location of " + classFileName + " file");
        }
        String jarProtocol = "jar:";
        String expectedProtocol = "jar:file:";
        String classFileUrlString = classFileUrl.toString();
        if (!classFileUrlString.startsWith("jar:file:")) {
            throw new IllegalStateException("Unknown protocol: " + classFileUrlString);
        }
        int index = classFileUrlString.indexOf(33);
        if (index == -1) {
            throw new IllegalStateException("Could not determine where " + classFileUrlString + " refers to");
        }
        URI rtJarUri = URI.create(classFileUrlString.substring("jar:".length(), index));
        Path rtJarPath = Paths.get(rtJarUri);
        if (Files.notExists(rtJarPath, new LinkOption[0])) {
            throw new IllegalStateException("JDK jar path is not a file: " + rtJarPath);
        }
        this.delegate = ClassProviderRoot.fromJar(rtJarPath);
    }

    @Override
    public byte @Nullable [] getClassData(@NotNull String fileName) throws IOException {
        return this.delegate.getClassData(fileName);
    }

    @Override
    @NotNull
    public List<? extends ClassProviderRoot.ClassDataReference> getAllClasses() throws IOException {
        return this.delegate.getAllClasses();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }
}

