/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.HypoModelUtilHelper;

public final class HypoModelUtil {
    private HypoModelUtil() {
    }

    @NotNull
    public static String normalizedClassName(@NotNull String className) {
        int index = className.endsWith(";") ? 1 : 0;
        return className.substring(index, className.length() - index).replace('.', '/');
    }

    @Contract(value="_ -> param1", pure=true)
    @Nullable
    public static <T> T cast(@Nullable Object o) {
        Object t = o;
        return (T)t;
    }

    @Contract(value="_ -> fail")
    public static <X extends Throwable> RuntimeException rethrow(@NotNull Throwable t) throws X {
        throw t;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T, R, X extends Throwable> ThrowingFunction<T, R, X> wrapFunction(@NotNull ThrowingFunction<T, R, X> func) {
        return func;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <T, X extends Throwable> ThrowingConsumer<T, X> wrapConsumer(@NotNull ThrowingConsumer<T, X> consumer) {
        return consumer;
    }

    @Contract(value="null, _ -> param2")
    @NotNull
    public static <T1 extends Throwable, T2 extends T1> T1 addSuppressed(@Nullable T1 base, @NotNull T2 thrown) {
        if (base == null) {
            return thrown;
        }
        base.addSuppressed((Throwable)thrown);
        return base;
    }

    @NotNull
    public static <T> List<T> asImmutableList(@NotNull Collection<T> collection) {
        return HypoModelUtilHelper.INSTANCE.asImmutableList(collection);
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, X extends Throwable>
    extends Consumer<T> {
        public void acceptThrowing(T var1) throws X;

        @Override
        default public void accept(T t) {
            try {
                this.acceptThrowing(t);
            }
            catch (Throwable x) {
                throw HypoModelUtil.rethrow(x);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, X extends Throwable>
    extends Function<T, R> {
        public R applyThrowing(T var1) throws X;

        @Override
        default public R apply(T t) {
            try {
                return this.applyThrowing(t);
            }
            catch (Throwable x) {
                throw HypoModelUtil.rethrow(x);
            }
        }
    }
}

