/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;

public class CopyMethodMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<CopyMethodMappingChange> {
    @NotNull
    private final MethodMapping mapping;

    private CopyMethodMappingChange(@NotNull MemberReference target, @NotNull MethodMapping mapping) {
        super(target);
        this.mapping = mapping;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CopyMethodMappingChange of(@NotNull MemberReference target, @NotNull MethodMapping mapping) {
        return new CopyMethodMappingChange(target, mapping);
    }

    @NotNull
    public MethodMapping methodMapping() {
        return this.mapping;
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map2 = input.getOrCreateClassMapping(target.className());
        MethodMapping newMapping = map2.getOrCreateMethodMapping(target.name(), target.desc());
        newMapping.setDeobfuscatedName(this.mapping.getDeobfuscatedName());
        for (MethodParameterMapping paramMapping : this.mapping.getParameterMappings()) {
            newMapping.getOrCreateParameterMapping(paramMapping.getIndex()).setDeobfuscatedName(paramMapping.getDeobfuscatedName());
        }
    }

    @Override
    @NotNull
    public MergeResult<CopyMethodMappingChange> mergeWith(@NotNull CopyMethodMappingChange that) {
        if (!this.mapping.getDeobfuscatedName().equals(that.mapping.getDeobfuscatedName())) {
            return MergeResult.failure("Cannot merge copies with different target mappings");
        }
        Collection<MethodParameterMapping> thisParams = this.mapping.getParameterMappings();
        Collection<MethodParameterMapping> thatParams = that.mapping.getParameterMappings();
        if (thisParams.size() > thatParams.size()) {
            return MergeResult.success(this);
        }
        return MergeResult.success(that);
    }

    public String toString() {
        return "Copy mapping '" + this.mapping.getFullDeobfuscatedName() + "' to " + this.target();
    }
}

