/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtilHelper;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.dev.denwav.hypo.model.data.types.ClassType;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.org.cadixdev.bombe.type.ArrayType;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.bombe.type.ObjectType;
import paper.libs.org.cadixdev.bombe.type.PrimitiveType;
import paper.libs.org.cadixdev.bombe.type.Type;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.impl.MappingSetImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.AbstractClassMappingImpl;
import paper.libs.org.cadixdev.lorenz.impl.model.MethodMappingImpl;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.InnerClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;
import paper.libs.org.cadixdev.lorenz.model.TopLevelClassMapping;

public final class LorenzUtil {
    private LorenzUtil() {
    }

    @Nullable
    public static <T> T unwrap(@Nullable Optional<T> opt) {
        if (opt == null) {
            return null;
        }
        return opt.orElse(null);
    }

    @Contract(pure=true)
    @Nullable
    public static MethodData findMethod(@NotNull ClassData classData, @NotNull MethodMapping mapping) {
        return classData.method(mapping.getObfuscatedName(), LorenzUtil.convertDesc(mapping.getDescriptor()));
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull Set<@NotNull FieldData> findField(@NotNull ClassData classData, @NotNull FieldMapping mapping) {
        FieldType type = LorenzUtil.getType(mapping);
        if (type == null) {
            return classData.fields(mapping.getObfuscatedName());
        }
        FieldData field = classData.field(mapping.getObfuscatedName(), LorenzUtil.convertType(type));
        if (field == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(field);
    }

    @NotNull
    public static MethodDescriptor convertDesc(@NotNull paper.libs.org.cadixdev.bombe.type.MethodDescriptor desc) {
        ArrayList<JvmType> params = new ArrayList<JvmType>(desc.getParamTypes().size());
        for (FieldType paramType : desc.getParamTypes()) {
            params.add(LorenzUtil.convertType(paramType));
        }
        return new MethodDescriptor(params, LorenzUtil.convertType(desc.getReturnType()));
    }

    @NotNull
    public static JvmType convertType(@NotNull Type type) {
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            return new paper.libs.dev.denwav.hypo.model.data.types.ArrayType(LorenzUtil.convertType(array.getComponent()), array.getDimCount());
        }
        if (type instanceof PrimitiveType) {
            return paper.libs.dev.denwav.hypo.model.data.types.PrimitiveType.fromChar(((PrimitiveType)type).getKey());
        }
        if (type instanceof ObjectType) {
            ObjectType obj = (ObjectType)type;
            return new ClassType(obj.getClassName());
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    @Nullable
    public static ClassMapping<?, ?> getClassMapping(@NotNull MappingSet mappings, @NotNull String obfuscatedName) {
        return LorenzUtil.unwrap(mappings.getClassMapping(obfuscatedName));
    }

    @Nullable
    public static MethodMapping getMethodMapping(@NotNull ClassMapping<?, ?> mapping, @NotNull String name2, @NotNull String desc) {
        return LorenzUtil.unwrap(mapping.getMethodMapping(name2, desc));
    }

    @Nullable
    public static FieldMapping getFieldMapping(@NotNull ClassMapping<?, ?> mapping, @NotNull String name2) {
        return LorenzUtil.unwrap(mapping.getFieldMapping(name2));
    }

    @Nullable
    public static FieldMapping getFieldMapping(@NotNull ClassMapping<?, ?> mapping, @NotNull FieldSignature sig) {
        return LorenzUtil.unwrap(mapping.getFieldMapping(sig));
    }

    @Nullable
    public static MethodParameterMapping getParameterMapping(@NotNull MethodMapping mapping, int index) {
        return LorenzUtil.unwrap(mapping.getParameterMapping(index));
    }

    @Nullable
    public static FieldType getType(@NotNull FieldMapping mapping) {
        return LorenzUtil.unwrap(mapping.getType());
    }

    public static void removeClassMapping(@NotNull ClassMapping<?, ?> mapping) {
        if (mapping instanceof TopLevelClassMapping) {
            LorenzUtil.removeTopLevelClassMapping(mapping, mapping.getMappings());
        } else if (mapping instanceof InnerClassMapping) {
            LorenzUtil.removeInnerClassMapping(mapping, (ClassMapping)((InnerClassMapping)mapping).getParent());
        }
    }

    public static void removeMethodMapping(@NotNull MethodMapping mapping) {
        LorenzUtil.removeMethodMapping(mapping, (ClassMapping)mapping.getParent());
    }

    public static void removeFieldMapping(@NotNull FieldMapping mapping) {
        LorenzUtil.removeFieldMapping(mapping, (ClassMapping)mapping.getParent());
    }

    public static void removeParamMapping(@NotNull MethodParameterMapping mapping) {
        LorenzUtil.removeParamMapping(mapping, (MethodMapping)mapping.getParent());
    }

    public static void removeTopLevelClassMapping(@NotNull ClassMapping<?, ?> topLevelClassMapping, @NotNull MappingSet mappingSet) {
        if (topLevelClassMapping instanceof TopLevelClassMapping) {
            LorenzUtil.getTopLevelClassesMap(mappingSet).values().remove(topLevelClassMapping);
        }
    }

    public static void removeInnerClassMapping(@NotNull ClassMapping<?, ?> innerClassMapping, @NotNull ClassMapping<?, ?> mapping) {
        if (innerClassMapping instanceof InnerClassMapping) {
            LorenzUtil.getInnerClassesMap(mapping).values().remove(innerClassMapping);
        }
    }

    public static void removeFieldMapping(@NotNull FieldMapping fieldMapping, @NotNull ClassMapping<?, ?> mapping) {
        LorenzUtil.getFieldsMap(mapping).values().remove(fieldMapping);
        LorenzUtil.getFieldsByNameMap(mapping).values().remove(fieldMapping);
    }

    public static void removeMethodMapping(@NotNull MethodMapping methodMapping, @NotNull ClassMapping<?, ?> mapping) {
        LorenzUtil.getMethodsMap(mapping).values().remove(methodMapping);
    }

    public static void removeParamMapping(@NotNull MethodParameterMapping paramMappings2, @NotNull MethodMapping mapping) {
        LorenzUtil.getParamsMap(mapping).values().remove(paramMappings2);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, TopLevelClassMapping> getTopLevelClassesMap(@NotNull MappingSet mappingSet) {
        return LorenzUtilHelper.INSTANCE.getTopLevelClassesMap(mappingSet);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, InnerClassMapping> getInnerClassesMap(@NotNull ClassMapping<?, ?> mapping) {
        return LorenzUtilHelper.INSTANCE.getInnerClassesMap(mapping);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<FieldSignature, FieldMapping> getFieldsMap(@NotNull ClassMapping<?, ?> mapping) {
        return LorenzUtilHelper.INSTANCE.getFieldsMap(mapping);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, FieldMapping> getFieldsByNameMap(@NotNull ClassMapping<?, ?> mapping) {
        return LorenzUtilHelper.INSTANCE.getFieldsByNameMap(mapping);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<MethodSignature, MethodMapping> getMethodsMap(@NotNull ClassMapping<?, ?> mapping) {
        return LorenzUtilHelper.INSTANCE.getMethodsMap(mapping);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<Integer, MethodParameterMapping> getParamsMap(@NotNull MethodMapping mapping) {
        return LorenzUtilHelper.INSTANCE.getParamsMap(mapping);
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static MappingSetImpl checkType(@NotNull MappingSet mappingSet) {
        if (!(mappingSet instanceof MappingSetImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + MappingSetImpl.class.getName());
        }
        return (MappingSetImpl)mappingSet;
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static AbstractClassMappingImpl<?, ?> checkType(@NotNull ClassMapping<?, ?> mapping) {
        if (!(mapping instanceof AbstractClassMappingImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + AbstractClassMappingImpl.class.getName());
        }
        return (AbstractClassMappingImpl)mapping;
    }

    @Contract(value="_ -> param1", pure=true)
    @NotNull
    static MethodMappingImpl checkType(@NotNull MethodMapping mapping) {
        if (!(mapping instanceof MethodMappingImpl)) {
            throw new IllegalArgumentException("Argument is not an instance of " + MethodMappingImpl.class.getName());
        }
        return (MethodMappingImpl)mapping;
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1", pure=true)
    @NotNull
    static <T> T notNull(@Nullable T t, String fieldName) {
        if (t == null) {
            throw new NullPointerException(AbstractClassMappingImpl.class.getName() + "." + fieldName + " is null");
        }
        return t;
    }
}

