/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm;

import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.asm.HypoAsmUtil;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.ConstructorData;
import paper.libs.dev.denwav.hypo.model.data.LazyConstructorData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.org.objectweb.asm.tree.MethodNode;

public class AsmConstructorData
extends LazyConstructorData
implements ConstructorData {
    @NotNull
    private final ClassData parentClass;
    @NotNull
    private final MethodNode node;

    public AsmConstructorData(@NotNull ClassData parentClass, @NotNull MethodNode node) {
        this.parentClass = parentClass;
        this.node = node;
    }

    @NotNull
    public MethodNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return HypoAsmUtil.accessToVisibility(this.node.access);
    }

    @Override
    public boolean isSynthetic() {
        return (this.node.access & 0x1000) != 0;
    }

    @Override
    @NotNull
    public ClassData parentClass() {
        return this.parentClass;
    }

    @Override
    @NotNull
    public MethodDescriptor computeDescriptor() {
        return MethodDescriptor.parseDescriptor(this.node.desc);
    }
}

