/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH&R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/ZippedTask;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "inputZip", "Lorg/gradle/api/file/RegularFileProperty;", "getInputZip", "()Lorg/gradle/api/file/RegularFileProperty;", "outputZip", "getOutputZip", "exec", "", "init", "run", "rootDir", "Ljava/nio/file/Path;", "paperweight-lib"})
public abstract class ZippedTask
extends BaseTask {
    @Optional
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputZip();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputZip();

    public abstract void run(@NotNull Path var1);

    @Override
    public void init() {
        this.getOutputZip().convention((Provider)UtilsKt.defaultOutput(this, "zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void exec() {
        Path outputZipFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputZip()));
        Path outputDir = UtilsKt.findOutputDir(outputZipFile);
        try {
            Path input = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getInputZip()));
            if (input != null) {
                ZipKt.unzip(input, outputDir);
            } else {
                Path path = outputDir;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            }
            this.run(outputDir);
            UtilsKt.ensureDeleted(outputZipFile);
            ZipKt.zip(outputDir, outputZipFile);
        }
        finally {
            FileKt.deleteRecursively$default(outputDir, null, 1, null);
        }
    }
}

