/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.tasks.CopyResources;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/CopyResources;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "includes", "Lorg/gradle/api/provider/ListProperty;", "", "getIncludes", "()Lorg/gradle/api/provider/ListProperty;", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "outputJar", "getOutputJar", "vanillaJar", "getVanillaJar", "run", "", "paperweight-lib"})
public abstract class CopyResources
extends BaseTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getVanillaJar();

    @Input
    @NotNull
    public abstract ListProperty<String> getIncludes();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    @TaskAction
    public final void run() {
        Path target;
        Path out = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar()));
        Path path = target = out.resolveSibling(PathsKt.getName((Path)out) + ".dir");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"target");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        this.getFs().copy(new Action(this, target){
            final /* synthetic */ CopyResources this$0;
            final /* synthetic */ Path $target;

            public final void execute(@NotNull CopySpec $this$copy) {
                Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$receiver");
                $this$copy.from((Object)this.this$0.getArchives().zipTree((Object)this.this$0.getVanillaJar()), new Action(this){
                    final /* synthetic */ run.1 this$0;

                    public final void execute(@NotNull CopySpec $this$from) {
                        Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$receiver");
                        for (String inc : (List)this.this$0.this$0.getIncludes().get()) {
                            $this$from.include(new String[]{inc});
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                $this$copy.into((Object)this.$target);
                $this$copy.from(new Object[]{this.this$0.getArchives().zipTree((Object)this.this$0.getInputJar())});
                $this$copy.into((Object)this.$target);
            }
            {
                this.this$0 = copyResources;
                this.$target = path;
            }
        });
        ZipKt.zip(target, this.getOutputJar());
        FileKt.deleteRecursively$default(target, null, 1, null);
    }
}

