/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.ZippedTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/papermc/paperweight/tasks/ApplyRawDiffPatches;", "Lio/papermc/paperweight/tasks/ZippedTask;", "()V", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "patchDir", "getPatchDir", "init", "", "run", "rootDir", "Ljava/nio/file/Path;", "paperweight-lib"})
public abstract class ApplyRawDiffPatches
extends ZippedTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @Optional
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @Override
    public void init() {
        super.init();
        this.getOutputZip().convention((Provider)UtilsKt.defaultOutput(this, "zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull Path rootDir) {
        Iterable iterable;
        Path patches;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Git.Companion.checkForGit();
        Path input = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir()));
        FileKt.copyRecursivelyTo(input, rootDir);
        Path path = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()));
        if (path == null) {
            return;
        }
        Path path2 = patches = path;
        String string = "*.patch";
        boolean bl = false;
        Object object = Files.newDirectoryStream(path2, string);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            iterable = (DirectoryStream)object;
            boolean bl4 = false;
            DirectoryStream directoryStream = iterable;
            Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
            Sequence it = CollectionsKt.asSequence((Iterable)directoryStream);
            boolean bl5 = false;
            iterable = SequencesKt.toMutableList((Sequence)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Iterable patchSet = iterable;
        CollectionsKt.sort((List)patchSet);
        Git git = new Git(rootDir, null, 2, null);
        for (Path patch : patchSet) {
            String[] stringArray = new String[2];
            stringArray[0] = "apply";
            object = patch;
            bl2 = false;
            stringArray[1] = ((Object)object.toAbsolutePath()).toString();
            git.invoke(stringArray).executeOut();
        }
    }
}

