/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.osgi.framework.connect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import paper.libs.org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public interface ConnectContent {
    public static final String TAG_OSGI_CONNECT = "osgi.connect";

    public Optional<Map<String, String>> getHeaders();

    public Iterable<String> getEntries() throws IOException;

    public Optional<ConnectEntry> getEntry(String var1);

    public Optional<ClassLoader> getClassLoader();

    public void open() throws IOException;

    public void close() throws IOException;

    @ConsumerType
    public static interface ConnectEntry {
        public String getName();

        public long getContentLength();

        public long getLastModified();

        default public byte[] getBytes() throws IOException {
            long longLength = this.getContentLength();
            if (longLength > 0x7FFFFFF7L) {
                throw new IOException("Entry is to big to fit into a byte[]: " + this.getName());
            }
            Throwable throwable = null;
            Object var4_4 = null;
            try (InputStream in = this.getInputStream();){
                int nRead;
                int length = (int)longLength;
                if (length > 0) {
                    int bytesread = 0;
                    byte[] result = new byte[length];
                    int readcount = 0;
                    while (bytesread < length) {
                        readcount = in.read(result, bytesread, length - bytesread);
                        bytesread += readcount;
                        if (readcount <= 0) break;
                    }
                    return result;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = in.read(data, 0, data.length)) > 0) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                return buffer.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public InputStream getInputStream() throws IOException;
    }
}

