/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import paper.libs.org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;

public class SystemPolicy
implements IBuddyPolicy {
    public static final byte BOOT = 0;
    public static final byte EXT = 1;
    public static final byte APP = 2;
    private static SystemPolicy[] instances = new SystemPolicy[3];
    private ClassLoader classLoader;

    public static SystemPolicy getInstance(byte type, ClassLoader bootLoader) {
        if (instances[type] == null) {
            SystemPolicy.instances[type] = new SystemPolicy();
            SystemPolicy.instances[type].classLoader = AccessController.doPrivileged(() -> SystemPolicy.createClassLoader(type, bootLoader));
        }
        return instances[type];
    }

    public SystemPolicy() {
    }

    public SystemPolicy(ClassLoader parent) {
        this.classLoader = parent;
    }

    static ClassLoader createClassLoader(byte type, ClassLoader bootLoader) {
        switch (type) {
            case 2: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader();
                }
                return bootLoader;
            }
            case 0: {
                return bootLoader;
            }
            case 1: {
                if (ClassLoader.getSystemClassLoader() != null) {
                    return ClassLoader.getSystemClassLoader().getParent();
                }
                return bootLoader;
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name2) {
        try {
            return this.classLoader.loadClass(name2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String name2) {
        return this.classLoader.getResource(name2);
    }

    @Override
    public Enumeration<URL> loadResources(String name2) {
        try {
            return this.classLoader.getResources(name2);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

