/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.framework;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.ServiceFactory;
import paper.libs.org.osgi.framework.ServiceRegistration;
import paper.libs.org.osgi.framework.wiring.BundleWiring;

class XMLParsingServiceFactory
implements ServiceFactory<Object> {
    private final boolean isSax;
    private final boolean setTccl;

    public XMLParsingServiceFactory(boolean isSax, boolean setTccl) {
        this.isSax = isSax;
        this.setTccl = setTccl;
    }

    @Override
    public Object getService(Bundle bundle, ServiceRegistration<Object> registration) {
        if (!this.setTccl || bundle == null) {
            return this.createService();
        }
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl;
            BundleWiring wiring = bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = cl = wiring == null ? null : wiring.getClassLoader();
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Object object = this.createService();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
    }

    private Object createService() {
        if (this.isSax) {
            return SAXParserFactory.newInstance();
        }
        return DocumentBuilderFactory.newInstance();
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {
    }
}

