/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import paper.libs.org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import paper.libs.org.eclipse.osgi.framework.util.SecureAction;
import paper.libs.org.eclipse.osgi.internal.connect.ConnectBundleFile;
import paper.libs.org.eclipse.osgi.internal.debug.Debug;
import paper.libs.org.eclipse.osgi.internal.framework.ContextFinder;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxEventPublisher;
import paper.libs.org.eclipse.osgi.internal.framework.StorageSaver;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import paper.libs.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import paper.libs.org.eclipse.osgi.internal.location.EquinoxLocations;
import paper.libs.org.eclipse.osgi.internal.log.EquinoxLogServices;
import paper.libs.org.eclipse.osgi.internal.messages.Msg;
import paper.libs.org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import paper.libs.org.eclipse.osgi.signedcontent.SignedContentFactory;
import paper.libs.org.eclipse.osgi.storage.BundleInfo;
import paper.libs.org.eclipse.osgi.storage.Storage;
import paper.libs.org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import paper.libs.org.eclipse.osgi.util.ManifestElement;
import paper.libs.org.eclipse.osgi.util.NLS;
import paper.libs.org.osgi.framework.AdminPermission;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleException;
import paper.libs.org.osgi.framework.FrameworkUtil;
import paper.libs.org.osgi.framework.connect.ConnectContent;
import paper.libs.org.osgi.framework.connect.ConnectModule;
import paper.libs.org.osgi.framework.connect.ModuleConnector;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public class EquinoxContainer
implements ThreadFactory,
Runnable {
    public static final String NAME = "paper.libs.org.eclipse.osgi";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final ConnectModules connectModules;
    private final EquinoxConfiguration equinoxConfig;
    private final EquinoxLogServices logServices;
    private final Storage storage;
    private final Set<String> bootDelegation;
    private final String[] bootDelegationStems;
    private final boolean bootDelegateAll;
    private final boolean isProcessClassRecursionSupportedByAll;
    private final EquinoxEventPublisher eventPublisher;
    private final Object monitor = new Object();
    private final ClassLoader bootLoader;
    private ServiceRegistry serviceRegistry;
    private ContextFinder contextFinder;
    private ServiceTracker<SignedContentFactory, SignedContentFactory> signedContentFactory;
    private ScheduledExecutorService executor;
    private StorageSaver storageSaver;

    public EquinoxContainer(Map<String, ?> configuration, ModuleConnector moduleConnector) {
        ClassLoader platformClassLoader = null;
        try {
            Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
            platformClassLoader = (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            platformClassLoader = new ClassLoader(Object.class.getClassLoader()){};
        }
        this.bootLoader = platformClassLoader;
        this.equinoxConfig = new EquinoxConfiguration(configuration, new HookRegistry(this));
        this.logServices = new EquinoxLogServices(this.equinoxConfig);
        this.equinoxConfig.logMessages(this.logServices);
        this.connectModules = new ConnectModules(moduleConnector);
        EquinoxContainer.initConnectFramework(moduleConnector, this.equinoxConfig);
        this.equinoxConfig.getHookRegistry().initialize();
        try {
            this.storage = Storage.createStorage(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error initializing storage for Equinox container.", e);
        }
        this.eventPublisher = new EquinoxEventPublisher(this);
        String bootDelegationProp = this.equinoxConfig.getConfiguration("paper.libs.org.osgi.framework.bootdelegation");
        String[] bootPackages = ManifestElement.getArrayFromList(bootDelegationProp, ",");
        HashSet<String> exactMatch = new HashSet<String>(bootPackages.length);
        ArrayList<String> stemMatch = new ArrayList<String>(bootPackages.length);
        boolean delegateAllValue = false;
        String[] stringArray = bootPackages;
        int n = bootPackages.length;
        int n2 = 0;
        while (n2 < n) {
            String bootPackage = stringArray[n2];
            if (bootPackage.equals("*")) {
                delegateAllValue = true;
                exactMatch.clear();
                stemMatch.clear();
                break;
            }
            if (bootPackage.endsWith("*")) {
                if (bootPackage.length() > 2 && bootPackage.endsWith(".*")) {
                    stemMatch.add(bootPackage.substring(0, bootPackage.length() - 1));
                }
            } else {
                exactMatch.add(bootPackage);
            }
            ++n2;
        }
        this.bootDelegateAll = delegateAllValue;
        this.bootDelegation = exactMatch;
        this.bootDelegationStems = stemMatch.isEmpty() ? null : stemMatch.toArray(new String[stemMatch.size()]);
        boolean supportRecursion = true;
        for (ClassLoaderHook hook : this.equinoxConfig.getHookRegistry().getClassLoaderHooks()) {
            supportRecursion &= hook.isProcessClassRecursionSupported();
        }
        this.isProcessClassRecursionSupportedByAll = supportRecursion;
    }

    private static void initConnectFramework(ModuleConnector moduleConnector, EquinoxConfiguration equinoxConfig) {
        if (moduleConnector == null) {
            return;
        }
        URL configUrl = equinoxConfig.getEquinoxLocations().getConfigurationLocation().getURL();
        File fwkStore = new File(configUrl.getPath());
        Map<String, Object> config = equinoxConfig.getInitialConfig();
        moduleConnector.initialize(fwkStore, Collections.unmodifiableMap(config));
    }

    public Storage getStorage() {
        return this.storage;
    }

    public EquinoxConfiguration getConfiguration() {
        return this.equinoxConfig;
    }

    public EquinoxLocations getLocations() {
        return this.equinoxConfig.getEquinoxLocations();
    }

    public EquinoxLogServices getLogServices() {
        return this.logServices;
    }

    public Bundle getBundle(Class<?> clazz) {
        Bundle b = FrameworkUtil.getBundle(clazz);
        if (b != null) {
            return b;
        }
        return AccessController.doPrivileged(() -> {
            if (clazz.getClassLoader() == EquinoxContainer.class.getClassLoader()) {
                return this.getStorage().getModuleContainer().getModule(0L).getBundle();
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignedContentFactory getSignedContentFactory() {
        ServiceTracker<SignedContentFactory, SignedContentFactory> current;
        Object object = this.monitor;
        synchronized (object) {
            current = this.signedContentFactory;
        }
        return current == null ? null : current.getService();
    }

    public boolean isBootDelegationPackage(String name2) {
        if (this.bootDelegateAll) {
            return true;
        }
        if (this.bootDelegation.contains(name2)) {
            return true;
        }
        if (this.bootDelegationStems != null) {
            String[] stringArray = this.bootDelegationStems;
            int n = this.bootDelegationStems.length;
            int n2 = 0;
            while (n2 < n) {
                String bootDelegationStem = stringArray[n2];
                if (name2.startsWith(bootDelegationStem)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isProcessClassRecursionSupportedByAll() {
        return this.isProcessClassRecursionSupportedByAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        this.eventPublisher.init();
        Object object = this.monitor;
        synchronized (object) {
            this.serviceRegistry = new ServiceRegistry(this);
            this.initializeContextFinder();
            this.executor = Executors.newScheduledThreadPool(1, this);
            this.executor.execute(this);
            this.storageSaver = new StorageSaver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ScheduledExecutorService currentExecutor;
        Storage currentStorage;
        StorageSaver currentSaver;
        Object object = this.monitor;
        synchronized (object) {
            this.serviceRegistry = null;
            currentSaver = this.storageSaver;
            currentStorage = this.storage;
            currentExecutor = this.executor;
        }
        currentSaver.close();
        currentStorage.close();
        currentExecutor.shutdown();
    }

    private void initializeContextFinder() {
        Thread current = Thread.currentThread();
        try {
            ClassLoader parent = null;
            String type = this.equinoxConfig.getConfiguration("osgi.contextClassLoaderParent");
            if ("app".equals(type)) {
                parent = ClassLoader.getSystemClassLoader();
            } else if ("boot".equals(type)) {
                parent = this.bootLoader;
            } else if ("fwk".equals(type)) {
                parent = EquinoxContainer.class.getClassLoader();
            } else if ("ext".equals(type)) {
                ClassLoader appCL = ClassLoader.getSystemClassLoader();
                if (appCL != null) {
                    parent = appCL.getParent();
                }
            } else {
                parent = current.getContextClassLoader();
            }
            this.contextFinder = new ContextFinder(parent, this.bootLoader);
            current.setContextClassLoader(this.contextFinder);
            return;
        }
        catch (Exception e) {
            this.logServices.log(NAME, 1, NLS.bind(Msg.CANNOT_SET_CONTEXTFINDER, null), e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EquinoxEventPublisher getEventPublisher() {
        Object object = this.monitor;
        synchronized (object) {
            return this.eventPublisher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScheduledExecutorService getScheduledExecutor() {
        Object object = this.monitor;
        synchronized (object) {
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistry getServiceRegistry() {
        Object object = this.monitor;
        synchronized (object) {
            return this.serviceRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextFinder getContextFinder() {
        Object object = this.monitor;
        synchronized (object) {
            return this.contextFinder;
        }
    }

    public <K, V, E> ListenerQueue<K, V, E> newListenerQueue() {
        return this.eventPublisher.newListenerQueue();
    }

    void checkAdminPermission(Bundle bundle, String action) {
        if (bundle == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, action));
        }
    }

    public void handleRuntimeError(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemStart(BundleContext bc) {
        Object object = this.monitor;
        synchronized (object) {
            this.signedContentFactory = new ServiceTracker(bc, SignedContentFactory.class, null);
        }
        this.signedContentFactory.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemStop(BundleContext bc) {
        ServiceTracker<SignedContentFactory, SignedContentFactory> current;
        Object object = this.monitor;
        synchronized (object) {
            current = this.signedContentFactory;
        }
        if (current != null) {
            current.close();
        }
    }

    public String toString() {
        String UUID2 = this.equinoxConfig == null ? null : this.equinoxConfig.getConfiguration("paper.libs.org.osgi.framework.uuid");
        return "Equinox Container: " + UUID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StorageSaver getStorageSaver() {
        Object object = this.monitor;
        synchronized (object) {
            return this.storageSaver;
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        String type = this.equinoxConfig.getConfiguration("osgi.framework.activeThreadType", "normal");
        Thread t = new Thread(r, "Active Thread: " + this.toString());
        if ("normal".equals(type)) {
            t.setDaemon(false);
        } else {
            t.setDaemon(true);
        }
        t.setPriority(5);
        return t;
    }

    @Override
    public void run() {
    }

    public ClassLoader getBootLoader() {
        return this.bootLoader;
    }

    public ConnectModules getConnectModules() {
        return this.connectModules;
    }

    public static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public static class ConnectModules {
        final ModuleConnector moduleConnector;
        private final ConcurrentMap<String, ConnectModule> connectModules = new ConcurrentHashMap<String, ConnectModule>();
        private final WeakHashMap<ConnectContent, WeakReference<ConnectBundleFile>> contents = new WeakHashMap();

        public ConnectModules(ModuleConnector moduleConnector) {
            this.moduleConnector = moduleConnector;
        }

        public ConnectModule connect(String location) {
            if (this.moduleConnector == null) {
                return null;
            }
            ConnectModule result = this.connectModules.compute(location, (k, v) -> {
                try {
                    return this.moduleConnector.connect(location).orElse(null);
                }
                catch (BundleException e) {
                    throw new IllegalStateException(e);
                }
            });
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectBundleFile getConnectBundleFile(ConnectModule module, File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug) throws IOException {
            ConnectContent content = module.getContent();
            WeakHashMap<ConnectContent, WeakReference<ConnectBundleFile>> weakHashMap = this.contents;
            synchronized (weakHashMap) {
                ConnectBundleFile bundleFile;
                WeakReference<ConnectBundleFile> ref = this.contents.get(content);
                if (ref != null && (bundleFile = (ConnectBundleFile)ref.get()) != null) {
                    return bundleFile;
                }
                bundleFile = new ConnectBundleFile(module, basefile, generation, mruList, debug);
                this.contents.put(content, new WeakReference<ConnectBundleFile>(bundleFile));
                return bundleFile;
            }
        }

        public ModuleConnector getModuleConnector() {
            return this.moduleConnector;
        }

        public ConnectModule getConnectModule(String location) {
            return (ConnectModule)this.connectModules.get(location);
        }
    }
}

