/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.debug;

import paper.libs.org.eclipse.osgi.internal.debug.EclipseDebugTrace;

public class FrameworkDebugTraceEntry {
    public static final String DEFAULT_OPTION_PATH = "/debug";
    private final String threadName = Thread.currentThread().getName();
    private final long timestamp;
    private final String optionPath;
    private final String bundleSymbolicName;
    private final String className;
    private final String methodName;
    private final int lineNumber;
    private String message;
    private final Throwable throwable;

    public FrameworkDebugTraceEntry(String bundleSymbolicName, String optionPath, String message, String traceClass) {
        this(bundleSymbolicName, optionPath, message, null, traceClass);
    }

    public FrameworkDebugTraceEntry(String bundleSymbolicName, String optionPath, String message, Throwable error, String traceClass) {
        this.optionPath = optionPath == null ? DEFAULT_OPTION_PATH : optionPath;
        this.timestamp = System.currentTimeMillis();
        this.bundleSymbolicName = bundleSymbolicName;
        this.message = message;
        this.throwable = error;
        String determineClassName = null;
        String determineMethodName = null;
        int determineLineNumber = 0;
        StackTraceElement[] stackElements = new Exception().getStackTrace();
        int i2 = 0;
        while (i2 < stackElements.length) {
            String fullClassName = stackElements[i2].getClassName();
            if (!(fullClassName.equals(Thread.class.getName()) || fullClassName.equals(FrameworkDebugTraceEntry.class.getName()) || fullClassName.equals(EclipseDebugTrace.class.getName()) || traceClass != null && fullClassName.equals(traceClass))) {
                determineClassName = stackElements[i2].getClassName();
                determineMethodName = stackElements[i2].getMethodName();
                determineLineNumber = stackElements[i2].getLineNumber();
                break;
            }
            ++i2;
        }
        this.className = determineClassName;
        this.methodName = determineMethodName;
        this.lineNumber = determineLineNumber;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.threadName);
        buffer.append(" ");
        buffer.append(this.timestamp);
        buffer.append(" ");
        buffer.append(this.bundleSymbolicName);
        buffer.append(" ");
        buffer.append(this.optionPath);
        buffer.append(" ");
        buffer.append(this.className);
        buffer.append(" ");
        buffer.append(this.methodName);
        buffer.append(" ");
        buffer.append(this.lineNumber);
        if (this.message != null) {
            buffer.append(": ");
            buffer.append(this.message);
        }
        if (this.throwable != null) {
            buffer.append(this.throwable);
        }
        return buffer.toString();
    }

    public final String getThreadName() {
        return this.threadName;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final String getOptionPath() {
        return this.optionPath;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    void setMessage(String newMessage) {
        this.message = newMessage;
    }
}

