/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jface.text;

import java.util.HashMap;
import java.util.Map;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.jface.text.IDocument;
import paper.libs.org.eclipse.jface.text.IRegion;
import paper.libs.org.eclipse.jface.text.Region;

public class DocumentPartitioningChangedEvent {
    private final IDocument fDocument;
    private final Map<String, Region> fMap = new HashMap<String, Region>();

    public DocumentPartitioningChangedEvent(IDocument document) {
        this.fDocument = document;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IRegion getChangedRegion(String partitioning) {
        return this.fMap.get(partitioning);
    }

    public String[] getChangedPartitionings() {
        String[] partitionings = new String[this.fMap.size()];
        this.fMap.keySet().toArray(partitionings);
        return partitionings;
    }

    public void setPartitionChange(String partitioning, int offset, int length) {
        Assert.isNotNull(partitioning);
        this.fMap.put(partitioning, new Region(offset, length));
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    public IRegion getCoverage() {
        if (this.fMap.isEmpty()) {
            return new Region(0, 0);
        }
        int offset = -1;
        int endOffset = -1;
        for (IRegion iRegion : this.fMap.values()) {
            int end;
            if (offset < 0 || iRegion.getOffset() < offset) {
                offset = iRegion.getOffset();
            }
            if ((end = iRegion.getOffset() + iRegion.getLength()) <= endOffset) continue;
            endOffset = end;
        }
        return new Region(offset, endOffset - offset);
    }
}

