/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.util;

import paper.libs.org.eclipse.jdt.core.util.ClassFormatException;
import paper.libs.org.eclipse.jdt.core.util.IConstantPool;
import paper.libs.org.eclipse.jdt.core.util.IExtendedAnnotation;
import paper.libs.org.eclipse.jdt.core.util.IRuntimeVisibleTypeAnnotationsAttribute;
import paper.libs.org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import paper.libs.org.eclipse.jdt.internal.core.util.ExtendedAnnotation;

public class RuntimeVisibleTypeAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeVisibleTypeAnnotationsAttribute {
    private static final IExtendedAnnotation[] NO_ENTRIES = new IExtendedAnnotation[0];
    private int extendedAnnotationsNumber;
    private IExtendedAnnotation[] extendedAnnotations;

    public RuntimeVisibleTypeAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.extendedAnnotationsNumber = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.extendedAnnotations = new IExtendedAnnotation[length];
            int i2 = 0;
            while (i2 < length) {
                ExtendedAnnotation extendedAnnotation = new ExtendedAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.extendedAnnotations[i2] = extendedAnnotation;
                readOffset += extendedAnnotation.sizeInBytes();
                ++i2;
            }
        } else {
            this.extendedAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IExtendedAnnotation[] getExtendedAnnotations() {
        return this.extendedAnnotations;
    }

    @Override
    public int getExtendedAnnotationsNumber() {
        return this.extendedAnnotationsNumber;
    }
}

