/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.OperationCanceledException;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.SearchParticipant;
import paper.libs.org.eclipse.jdt.core.search.SearchPattern;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import paper.libs.org.eclipse.jdt.internal.core.index.EntryResult;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;
import paper.libs.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public abstract class IntersectingPattern
extends JavaSearchPattern {
    public IntersectingPattern(int patternKind, int matchRule) {
        super(patternKind, matchRule);
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.resetQuery();
        SimpleSet intersectedNames = null;
        try {
            index.startQuery();
            do {
                SearchPattern pattern;
                EntryResult[] entries;
                if ((entries = (pattern = this.currentPattern()).queryIn(index)) == null) {
                    return;
                }
                SearchPattern decodedResult = pattern.getBlankPattern();
                SimpleSet newIntersectedNames = new SimpleSet(3);
                int i2 = 0;
                int l = entries.length;
                while (i2 < l) {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    EntryResult entry = entries[i2];
                    decodedResult.decodeIndexKey(entry.getWord());
                    if (pattern.matchesDecodedKey(decodedResult)) {
                        int n;
                        int j;
                        String[] names = entry.getDocumentNames(index);
                        if (intersectedNames != null) {
                            j = 0;
                            n = names.length;
                            while (j < n) {
                                if (intersectedNames.includes(names[j])) {
                                    newIntersectedNames.add(names[j]);
                                }
                                ++j;
                            }
                        } else {
                            j = 0;
                            n = names.length;
                            while (j < n) {
                                newIntersectedNames.add(names[j]);
                                ++j;
                            }
                        }
                    }
                    ++i2;
                }
                if (newIntersectedNames.elementSize == 0) {
                    return;
                }
                intersectedNames = newIntersectedNames;
            } while (this.hasNextQuery());
        }
        finally {
            index.stopQuery();
        }
        String containerPath = index.containerPath;
        char separator = index.separator;
        Object[] names = intersectedNames.values;
        int i3 = 0;
        int l = names.length;
        while (i3 < l) {
            if (names[i3] != null) {
                this.acceptMatch((String)names[i3], containerPath, separator, null, requestor, participant, scope, progressMonitor);
            }
            ++i3;
        }
    }

    protected abstract boolean hasNextQuery();

    protected abstract void resetQuery();
}

