/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import paper.libs.org.eclipse.jdt.internal.core.index.EntryResult;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;
import paper.libs.org.eclipse.jdt.internal.core.index.IndexLocation;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;

public class MetaIndex {
    private Index decoratee;
    private Set<String> indexesNotInMeta = null;

    public MetaIndex(Index decoratee) {
        this.decoratee = decoratee;
    }

    public IndexLocation getIndexLocation() {
        return this.decoratee.getIndexLocation();
    }

    public ReadWriteMonitor getMonitor() {
        return this.decoratee.monitor;
    }

    public void remove(String indexName) {
        this.decoratee.remove(indexName);
        Optional.ofNullable(this.indexesNotInMeta).ifPresent(i2 -> {
            boolean bl = i2.add(indexName);
        });
    }

    public void addIndexEntry(char[] metaCategory, char[] qualifier, String name2) {
        this.decoratee.addIndexEntry(metaCategory, qualifier, name2);
        Optional.ofNullable(this.indexesNotInMeta).ifPresent(i2 -> {
            boolean bl = i2.remove(name2);
        });
    }

    public Index getIndex() {
        return this.decoratee;
    }

    public void startQuery() {
        this.decoratee.startQuery();
    }

    public EntryResult[] query(char[][] categories, char[] indexQualifier, int matchRule) throws IOException {
        return this.decoratee.query(categories, indexQualifier, matchRule);
    }

    public Set<String> getIndexesNotInMeta(SimpleLookupTable indexes) throws IOException {
        if (this.indexesNotInMeta == null) {
            String[] documentNames = this.decoratee.queryDocumentNames(null);
            HashSet<String> names = new HashSet<String>(Arrays.asList(documentNames == null ? new String[]{} : documentNames));
            this.indexesNotInMeta = Stream.of(indexes.keyTable).filter(Objects::nonNull).map(IndexLocation.class::cast).map(IndexLocation::fileName).filter(n -> !names.contains(n)).collect(Collectors.toSet());
        }
        return this.indexesNotInMeta;
    }

    public void stopQuery() {
        this.decoratee.stopQuery();
        if (this.decoratee.diskIndex.getCacheUserCount() < 0) {
            this.indexesNotInMeta = null;
        }
    }

    public boolean hasChanged() {
        return this.decoratee.hasChanged();
    }

    public void save() throws IOException {
        this.decoratee.save();
    }
}

