/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.List;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.NodeRewriteEvent;
import paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.RewriteEvent;

public class ListRewriteEvent
extends RewriteEvent {
    public static final int NEW = 1;
    public static final int OLD = 2;
    public static final int BOTH = 3;
    private List originalNodes;
    private List listEntries;

    public ListRewriteEvent(List originalNodes) {
        this.originalNodes = new ArrayList(originalNodes);
    }

    public ListRewriteEvent(RewriteEvent[] children) {
        this.listEntries = new ArrayList(children.length * 2);
        this.originalNodes = new ArrayList(children.length * 2);
        int i2 = 0;
        while (i2 < children.length) {
            RewriteEvent curr = children[i2];
            this.listEntries.add(curr);
            if (curr.getOriginalValue() != null) {
                this.originalNodes.add(curr.getOriginalValue());
            }
            ++i2;
        }
    }

    private List getEntries() {
        if (this.listEntries == null) {
            int nNodes = this.originalNodes.size();
            this.listEntries = new ArrayList(nNodes * 2);
            int i2 = 0;
            while (i2 < nNodes) {
                ASTNode node = (ASTNode)this.originalNodes.get(i2);
                this.listEntries.add(new NodeRewriteEvent(node, node));
                ++i2;
            }
        }
        return this.listEntries;
    }

    @Override
    public int getChangeKind() {
        if (this.listEntries != null) {
            int i2 = 0;
            while (i2 < this.listEntries.size()) {
                RewriteEvent curr = (RewriteEvent)this.listEntries.get(i2);
                if (curr.getChangeKind() != 0) {
                    return 8;
                }
                ++i2;
            }
        }
        return 0;
    }

    @Override
    public boolean isListRewrite() {
        return true;
    }

    @Override
    public RewriteEvent[] getChildren() {
        List entries = this.getEntries();
        return entries.toArray(new RewriteEvent[entries.size()]);
    }

    @Override
    public Object getOriginalValue() {
        return this.originalNodes;
    }

    @Override
    public Object getNewValue() {
        List entries = this.getEntries();
        ArrayList<Object> res = new ArrayList<Object>(entries.size());
        int i2 = 0;
        while (i2 < entries.size()) {
            RewriteEvent curr = (RewriteEvent)entries.get(i2);
            Object newVal = curr.getNewValue();
            if (newVal != null) {
                res.add(newVal);
            }
            ++i2;
        }
        return res;
    }

    public RewriteEvent removeEntry(ASTNode originalEntry) {
        return this.replaceEntry(originalEntry, null);
    }

    public RewriteEvent replaceEntry(ASTNode entry, ASTNode newEntry) {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        List entries = this.getEntries();
        int nEntries = entries.size();
        int i2 = 0;
        while (i2 < nEntries) {
            NodeRewriteEvent curr = (NodeRewriteEvent)entries.get(i2);
            if (curr.getOriginalValue() == entry || curr.getNewValue() == entry) {
                curr.setNewValue(newEntry);
                if (curr.getNewValue() == null && curr.getOriginalValue() == null) {
                    entries.remove(i2);
                    return null;
                }
                return curr;
            }
            ++i2;
        }
        return null;
    }

    public void revertChange(NodeRewriteEvent event) {
        Object originalValue = event.getOriginalValue();
        if (originalValue == null) {
            List entries = this.getEntries();
            entries.remove(event);
        } else {
            event.setNewValue(originalValue);
        }
    }

    public int getIndex(ASTNode node, int kind) {
        List entries = this.getEntries();
        int i2 = entries.size() - 1;
        while (i2 >= 0) {
            RewriteEvent curr = (RewriteEvent)entries.get(i2);
            if ((kind & 2) != 0 && curr.getOriginalValue() == node) {
                return i2;
            }
            if ((kind & 1) != 0 && curr.getNewValue() == node) {
                return i2;
            }
            --i2;
        }
        return -1;
    }

    public RewriteEvent insert(ASTNode insertedNode, int insertIndex) {
        NodeRewriteEvent change = new NodeRewriteEvent(null, insertedNode);
        if (insertIndex != -1) {
            this.getEntries().add(insertIndex, change);
        } else {
            this.getEntries().add(change);
        }
        return change;
    }

    public void setNewValue(ASTNode newValue, int insertIndex) {
        NodeRewriteEvent curr = (NodeRewriteEvent)this.getEntries().get(insertIndex);
        curr.setNewValue(newValue);
    }

    public int getChangeKind(int index) {
        return ((NodeRewriteEvent)this.getEntries().get(index)).getChangeKind();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" [list change\n\t");
        RewriteEvent[] events = this.getChildren();
        int i2 = 0;
        while (i2 < events.length) {
            if (i2 != 0) {
                buf.append("\n\t");
            }
            buf.append(events[i2]);
            ++i2;
        }
        buf.append("\n]");
        return buf.toString();
    }
}

