/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModel;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.ChangeClasspathOperation;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathChange;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class SetVariablesOperation
extends ChangeClasspathOperation {
    String[] variableNames;
    IPath[] variablePaths;
    boolean updatePreferences;

    public SetVariablesOperation(String[] variableNames, IPath[] variablePaths, boolean updatePreferences) {
        super(new IJavaElement[]{JavaModelManager.getJavaModelManager().getJavaModel()}, !ResourcesPlugin.getWorkspace().isTreeLocked());
        this.variableNames = variableNames;
        this.variablePaths = variablePaths;
        this.updatePreferences = updatePreferences;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaModelManager manager;
            this.beginTask("", 1);
            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                this.verbose_set_variables();
            }
            if ((manager = JavaModelManager.getJavaModelManager()).variablePutIfInitializingWithSameValue(this.variableNames, this.variablePaths)) {
                return;
            }
            int varLength = this.variableNames.length;
            HashMap<JavaProject, IClasspathEntry[]> affectedProjectClasspaths = new HashMap<JavaProject, IClasspathEntry[]>(5);
            IJavaModel model = this.getJavaModel();
            int discardCount = 0;
            int i2 = 0;
            while (i2 < varLength) {
                String variableName = this.variableNames[i2];
                IPath oldPath = manager.variableGet(variableName);
                if (oldPath == JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                    oldPath = null;
                }
                if (oldPath != null && oldPath.equals(this.variablePaths[i2])) {
                    this.variableNames[i2] = null;
                    ++discardCount;
                }
                ++i2;
            }
            if (discardCount > 0) {
                if (discardCount == varLength) {
                    return;
                }
                int changedLength = varLength - discardCount;
                String[] changedVariableNames = new String[changedLength];
                IPath[] changedVariablePaths = new IPath[changedLength];
                int i3 = 0;
                int index = 0;
                while (i3 < varLength) {
                    if (this.variableNames[i3] != null) {
                        changedVariableNames[index] = this.variableNames[i3];
                        changedVariablePaths[index] = this.variablePaths[i3];
                        ++index;
                    }
                    ++i3;
                }
                this.variableNames = changedVariableNames;
                this.variablePaths = changedVariablePaths;
                varLength = changedLength;
            }
            if (this.isCanceled()) {
                return;
            }
            IJavaProject[] projects = model.getJavaProjects();
            int i4 = 0;
            int projectLength = projects.length;
            while (i4 < projectLength) {
                JavaProject project = (JavaProject)projects[i4];
                IClasspathEntry[] classpath = project.getRawClasspath();
                int j = 0;
                int cpLength = classpath.length;
                block13: while (j < cpLength) {
                    IClasspathEntry entry = classpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = this.variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath());
                                break block13;
                            }
                            IPath sourcePath = entry.getSourceAttachmentPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getSourceAttachmentRootPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath());
                                break block13;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < varLength) {
                manager.variablePut(this.variableNames[i4], this.variablePaths[i4]);
                if (this.updatePreferences) {
                    manager.variablePreferencesPut(this.variableNames[i4], this.variablePaths[i4]);
                }
                ++i4;
            }
            if (affectedProjectClasspaths.isEmpty()) return;
            String[] dbgVariableNames = this.variableNames;
            try {
                Iterator projectsToUpdate = affectedProjectClasspaths.keySet().iterator();
                while (projectsToUpdate.hasNext()) {
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        return;
                    }
                    JavaProject affectedProject = (JavaProject)projectsToUpdate.next();
                    if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                        this.verbose_update_project(dbgVariableNames, affectedProject);
                    }
                    ClasspathChange classpathChange = affectedProject.getPerProjectInfo().resetResolvedClasspath();
                    this.classpathChanged(classpathChange, true);
                    if (!this.canChangeResources) continue;
                    affectedProject.getProject().touch(this.progressMonitor);
                }
                return;
            }
            catch (CoreException e) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                    this.verbose_failure(dbgVariableNames);
                    e.printStackTrace();
                }
                if (!(e instanceof JavaModelException)) throw new JavaModelException(e);
                throw (JavaModelException)e;
            }
        }
        finally {
            this.done();
        }
    }

    private void verbose_failure(String[] dbgVariableNames) {
        Util.verbose("CPVariable SET  - FAILED DUE TO EXCEPTION\n\tvariables: " + paper.libs.org.eclipse.jdt.internal.compiler.util.Util.toString(dbgVariableNames), System.err);
    }

    private void verbose_update_project(String[] dbgVariableNames, JavaProject affectedProject) {
        Util.verbose("CPVariable SET  - updating affected project due to setting variables\n\tproject: " + affectedProject.getElementName() + '\n' + "\tvariables: " + paper.libs.org.eclipse.jdt.internal.compiler.util.Util.toString(dbgVariableNames));
    }

    private void verbose_set_variables() {
        Util.verbose("CPVariable SET  - setting variables\n\tvariables: " + paper.libs.org.eclipse.jdt.internal.compiler.util.Util.toString(this.variableNames) + '\n' + "\tvalues: " + paper.libs.org.eclipse.jdt.internal.compiler.util.Util.toString(this.variablePaths));
    }
}

