/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.Iterator;
import paper.libs.org.eclipse.jdt.core.Flags;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IImportDeclaration;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.JavaConventions;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.dom.AST;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.core.dom.ImportDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.Name;
import paper.libs.org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import paper.libs.org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;

public class CreateImportOperation
extends CreateElementInCUOperation {
    protected String importName;
    protected int flags;

    public CreateImportOperation(String importName, ICompilationUnit parentElement, int flags) {
        super(parentElement);
        this.importName = importName;
        this.flags = flags;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return CompilationUnit.IMPORTS_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        Iterator imports = this.cuAST.imports().iterator();
        boolean onDemand = this.importName.endsWith(".*");
        String importActualName = this.importName;
        if (onDemand) {
            importActualName = this.importName.substring(0, this.importName.length() - 2);
        }
        while (imports.hasNext()) {
            ImportDeclaration importDeclaration = (ImportDeclaration)imports.next();
            if (!importActualName.equals(importDeclaration.getName().getFullyQualifiedName()) || onDemand != importDeclaration.isOnDemand() || Flags.isStatic(this.flags) != importDeclaration.isStatic()) continue;
            this.creationOccurred = false;
            return null;
        }
        AST ast = this.cuAST.getAST();
        ImportDeclaration importDeclaration = ast.newImportDeclaration();
        importDeclaration.setStatic(Flags.isStatic(this.flags));
        char[][] charFragments = CharOperation.splitOn('.', importActualName.toCharArray(), 0, importActualName.length());
        int length = charFragments.length;
        String[] strFragments = new String[length];
        int i2 = 0;
        while (i2 < length) {
            strFragments[i2] = String.valueOf(charFragments[i2]);
            ++i2;
        }
        Name name2 = ast.newName(strFragments);
        importDeclaration.setName(name2);
        if (onDemand) {
            importDeclaration.setOnDemand(true);
        }
        return importDeclaration;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getImport(this.importName);
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createImportsProgress;
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createAfter(imports[imports.length - 1]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
            IJavaElement[] children = cu.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2].getElementType() == 11) {
                    this.createAfter(children[i2]);
                    return;
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validateImportDeclaration(this.importName, project.getOption("paper.libs.org.eclipse.jdt.core.compiler.source", true), project.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.importName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

