/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.jdt.core.IAnnotation;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.ISourceRange;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import paper.libs.org.eclipse.jdt.internal.core.Annotation;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.NamedMember;
import paper.libs.org.eclipse.jdt.internal.core.SourceMapper;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public abstract class BinaryMember
extends NamedMember {
    protected BinaryMember(JavaElement parent, String name2) {
        super(parent, name2);
    }

    @Override
    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    protected IAnnotation[] getAnnotations(IBinaryAnnotation[] binaryAnnotations, long tagBits) {
        IAnnotation[] standardAnnotations = this.getStandardAnnotations(tagBits);
        if (binaryAnnotations == null) {
            return standardAnnotations;
        }
        int length = binaryAnnotations.length;
        int standardLength = standardAnnotations.length;
        int fullLength = length + standardLength;
        if (fullLength == 0) {
            return Annotation.NO_ANNOTATIONS;
        }
        IAnnotation[] annotations = new IAnnotation[fullLength];
        int i2 = 0;
        while (i2 < length) {
            annotations[i2] = Util.getAnnotation(this, binaryAnnotations[i2], null);
            ++i2;
        }
        System.arraycopy(standardAnnotations, 0, annotations, length, standardLength);
        return annotations;
    }

    private IAnnotation getAnnotation(char[][] annotationName) {
        return new Annotation(this, new String(CharOperation.concatWith(annotationName, '.')));
    }

    protected IAnnotation[] getStandardAnnotations(long tagBits) {
        if ((tagBits & 0x77FFFFF840000000L) == 0L) {
            return Annotation.NO_ANNOTATIONS;
        }
        ArrayList<IAnnotation> annotations = new ArrayList<IAnnotation>();
        if ((tagBits & 0x300000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_RETENTION));
        }
        if ((tagBits & 0x400000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_DEPRECATED));
        }
        if ((tagBits & 0x800000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED));
        }
        if ((tagBits & 0x1000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_INHERITED));
        }
        if ((tagBits & 0x10000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE));
        }
        if ((tagBits & 0x8000000000000L) != 0L) {
            annotations.add(this.getAnnotation(TypeConstants.JAVA_LANG_SAFEVARARGS));
        }
        return annotations.toArray(new IAnnotation[annotations.size()]);
    }

    @Override
    public String[] getCategories() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            String[] categories;
            this.getClassFile().getBuffer();
            if (mapper.categories != null && (categories = (String[])mapper.categories.get(this)) != null) {
                return categories;
            }
        }
        return CharOperation.NO_STRINGS;
    }

    public String getKey() {
        try {
            return this.getKey(false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public abstract String getKey(boolean var1) throws JavaModelException;

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            this.getClassFile().getBuffer();
            return mapper.getNameRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            this.getClassFile().getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isStructureKnown() throws JavaModelException {
        return ((IJavaElement)((Object)this.getOpenableParent())).isStructureKnown();
    }

    @Override
    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    @Override
    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public void setContents(String contents2, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }
}

