/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.ast;

import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Annotation;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference type, int sourceStart) {
        this.type = type;
        this.sourceStart = sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    @Override
    public ElementValuePair[] computeElementValuePairs() {
        int numberOfPairs;
        int n = numberOfPairs = this.memberValuePairs == null ? 0 : this.memberValuePairs.length;
        if (numberOfPairs == 0) {
            return Binding.NO_ELEMENT_VALUE_PAIRS;
        }
        ElementValuePair[] pairs = new ElementValuePair[numberOfPairs];
        int i2 = 0;
        while (i2 < numberOfPairs) {
            pairs[i2] = this.memberValuePairs[i2].compilerElementPair;
            ++i2;
        }
        return pairs;
    }

    @Override
    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? NoValuePairs : this.memberValuePairs;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        super.printExpression(indent, output);
        output.append('(');
        if (this.memberValuePairs != null) {
            int i2 = 0;
            int max = this.memberValuePairs.length;
            while (i2 < max) {
                if (i2 > 0) {
                    output.append(',');
                }
                this.memberValuePairs[i2].print(indent, output);
                ++i2;
            }
        }
        output.append(')');
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.memberValuePairs != null) {
                int memberValuePairsLength = this.memberValuePairs.length;
                int i2 = 0;
                while (i2 < memberValuePairsLength) {
                    this.memberValuePairs[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.memberValuePairs != null) {
                int memberValuePairsLength = this.memberValuePairs.length;
                int i2 = 0;
                while (i2 < memberValuePairsLength) {
                    this.memberValuePairs[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

