/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.codeassist;

import java.util.Stack;
import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Argument;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Block;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TryStatement;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleSet;

public class ThrownExceptionFinder
extends ASTVisitor {
    private SimpleSet thrownExceptions;
    private Stack exceptionsStack;
    private SimpleSet caughtExceptions;
    private SimpleSet discouragedExceptions;

    public void processThrownExceptions(TryStatement tryStatement, BlockScope scope) {
        this.thrownExceptions = new SimpleSet();
        this.exceptionsStack = new Stack();
        this.caughtExceptions = new SimpleSet();
        this.discouragedExceptions = new SimpleSet();
        tryStatement.traverse(this, scope);
        this.removeCaughtExceptions(tryStatement, true);
    }

    private void acceptException(ReferenceBinding binding) {
        if (binding != null && binding.isValidBinding()) {
            this.thrownExceptions.add(binding);
        }
    }

    @Override
    public void endVisit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.binding != null) {
            this.endVisitMethodInvocation(messageSend.binding);
        }
        super.endVisit(messageSend, scope);
    }

    @Override
    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        if (allocationExpression.binding != null) {
            this.endVisitMethodInvocation(allocationExpression.binding);
        }
        super.endVisit(allocationExpression, scope);
    }

    @Override
    public void endVisit(ThrowStatement throwStatement, BlockScope scope) {
        this.acceptException((ReferenceBinding)throwStatement.exception.resolvedType);
        super.endVisit(throwStatement, scope);
    }

    private void endVisitMethodInvocation(MethodBinding methodBinding) {
        ReferenceBinding[] thrownExceptionBindings = methodBinding.thrownExceptions;
        int length = thrownExceptionBindings == null ? 0 : thrownExceptionBindings.length;
        int i2 = 0;
        while (i2 < length) {
            this.acceptException(thrownExceptionBindings[i2]);
            ++i2;
        }
    }

    public ReferenceBinding[] getAlreadyCaughtExceptions() {
        Object[] allCaughtExceptions = new ReferenceBinding[this.caughtExceptions.elementSize];
        this.caughtExceptions.asArray(allCaughtExceptions);
        return allCaughtExceptions;
    }

    public ReferenceBinding[] getThrownUncaughtExceptions() {
        Object[] result = new ReferenceBinding[this.thrownExceptions.elementSize];
        this.thrownExceptions.asArray(result);
        return result;
    }

    public ReferenceBinding[] getDiscouragedExceptions() {
        Object[] allDiscouragedExceptions = new ReferenceBinding[this.discouragedExceptions.elementSize];
        this.discouragedExceptions.asArray(allDiscouragedExceptions);
        return allDiscouragedExceptions;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        return this.visitType(typeDeclaration);
    }

    @Override
    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        return this.visitType(memberTypeDeclaration);
    }

    @Override
    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        return this.visitType(localTypeDeclaration);
    }

    private boolean visitType(TypeDeclaration typeDeclaration) {
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        SimpleSet exceptionSet;
        this.exceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = exceptionSet = new SimpleSet();
        tryStatement.tryBlock.traverse(this, scope);
        this.removeCaughtExceptions(tryStatement, false);
        this.thrownExceptions = (SimpleSet)this.exceptionsStack.pop();
        Object[] values = exceptionSet.values;
        int i2 = 0;
        while (i2 < values.length) {
            if (values[i2] != null) {
                this.thrownExceptions.add(values[i2]);
            }
            ++i2;
        }
        Block[] catchBlocks = tryStatement.catchBlocks;
        int length = catchBlocks == null ? 0 : catchBlocks.length;
        int i3 = 0;
        while (i3 < length) {
            catchBlocks[i3].traverse(this, scope);
            ++i3;
        }
        return false;
    }

    private void removeCaughtExceptions(TryStatement tryStatement, boolean recordUncheckedCaughtExceptions) {
        Argument[] catchArguments = tryStatement.catchArguments;
        int length = catchArguments == null ? 0 : catchArguments.length;
        int i2 = 0;
        while (i2 < length) {
            if (catchArguments[i2].type instanceof UnionTypeReference) {
                UnionTypeReference unionTypeReference = (UnionTypeReference)catchArguments[i2].type;
                int j = 0;
                while (j < unionTypeReference.typeReferences.length) {
                    TypeBinding caughtException = unionTypeReference.typeReferences[j].resolvedType;
                    if (caughtException instanceof ReferenceBinding && caughtException.isValidBinding()) {
                        if (recordUncheckedCaughtExceptions) {
                            this.removeCaughtException((ReferenceBinding)caughtException);
                            this.caughtExceptions.add(caughtException);
                        } else if (!caughtException.isUncheckedException(true)) {
                            this.discouragedExceptions.add(caughtException);
                        }
                    }
                    ++j;
                }
            } else {
                TypeBinding exception = catchArguments[i2].type.resolvedType;
                if (exception instanceof ReferenceBinding && exception.isValidBinding()) {
                    if (recordUncheckedCaughtExceptions) {
                        this.removeCaughtException((ReferenceBinding)exception);
                        this.caughtExceptions.add(exception);
                    } else if (!exception.isUncheckedException(true)) {
                        this.discouragedExceptions.add(exception);
                    }
                }
            }
            ++i2;
        }
    }

    private void removeCaughtException(ReferenceBinding caughtException) {
        Object[] exceptions = this.thrownExceptions.values;
        int i2 = 0;
        while (i2 < exceptions.length) {
            ReferenceBinding exception = (ReferenceBinding)exceptions[i2];
            if (exception != null) {
                if (TypeBinding.equalsEquals(exception, caughtException)) {
                    this.thrownExceptions.remove(exception);
                } else if (caughtException.isSuperclassOf(exception)) {
                    this.thrownExceptions.remove(exception);
                    this.discouragedExceptions.add(exception);
                }
            }
            ++i2;
        }
    }
}

