/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import paper.libs.org.eclipse.jdt.core.dom.AST;
import paper.libs.org.eclipse.jdt.core.dom.ASTMatcher;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTVisitor;
import paper.libs.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import paper.libs.org.eclipse.jdt.core.dom.Expression;
import paper.libs.org.eclipse.jdt.core.dom.SimpleName;
import paper.libs.org.eclipse.jdt.core.dom.Statement;

public class SwitchStatement
extends Statement {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(SwitchStatement.class, "expression", Expression.class, true, true);
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(SwitchStatement.class, "statements", Statement.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Expression expression = null;
    private ASTNode.NodeList statements = new ASTNode.NodeList(STATEMENTS_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(3);
        SwitchStatement.createPropertyList(SwitchStatement.class, propertyList);
        SwitchStatement.addProperty(EXPRESSION_PROPERTY, propertyList);
        SwitchStatement.addProperty(STATEMENTS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SwitchStatement.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    SwitchStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SwitchStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 50;
    }

    @Override
    ASTNode clone0(AST target) {
        SwitchStatement result = new SwitchStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)this.getExpression().clone(target));
        result.statements().addAll(ASTNode.copySubtrees(target, this.statements()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChildren(visitor, this.statements);
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            SwitchStatement switchStatement = this;
            synchronized (switchStatement) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public List statements() {
        return this.statements;
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + this.statements.listSize();
    }
}

