/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime;

import paper.libs.org.eclipse.core.runtime.IProgressMonitor;

public class SlicedProgressMonitor
implements IProgressMonitor {
    private final int slicedWork;
    private final IProgressMonitor monitor;
    private Boolean canceled;
    private double increment;
    private String taskName;
    private double accumulator;
    private int workUnits;
    private boolean beginTaskCalled;
    private String subTaskName;

    public SlicedProgressMonitor(IProgressMonitor monitor, int totalWork) {
        this.monitor = monitor;
        this.slicedWork = totalWork;
        this.workUnits = totalWork;
    }

    @Override
    public void beginTask(String name2, int totalWork) {
        if (this.beginTaskCalled) {
            throw new IllegalStateException("This must only be called once on a given progress monitor instance.");
        }
        this.taskName = name2;
        if (totalWork > 0) {
            this.increment = (double)this.slicedWork / (double)totalWork;
        }
        this.beginTaskCalled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        if (this.workUnits > 0) {
            IProgressMonitor iProgressMonitor = this.monitor;
            synchronized (iProgressMonitor) {
                this.monitor.worked(this.workUnits);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalWorked(double internalWork) {
        this.accumulator += internalWork;
        int workConsumed = 0;
        while (this.accumulator >= 1.0 && this.workUnits > 0) {
            this.accumulator -= 1.0;
            --this.workUnits;
            ++workConsumed;
        }
        if (workConsumed > 0) {
            IProgressMonitor iProgressMonitor = this.monitor;
            synchronized (iProgressMonitor) {
                this.monitor.worked(workConsumed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled != null) {
            return this.canceled;
        }
        IProgressMonitor iProgressMonitor = this.monitor;
        synchronized (iProgressMonitor) {
            return this.monitor.isCanceled();
        }
    }

    @Override
    public void setCanceled(boolean value) {
        this.canceled = value;
    }

    @Override
    public void setTaskName(String name2) {
        this.taskName = name2;
    }

    @Override
    public void subTask(String name2) {
        this.subTaskName = name2;
    }

    @Override
    public void worked(int work) {
        if (work > 0 && this.increment > 0.0) {
            this.internalWorked((double)work * this.increment);
        }
    }

    public String getName() {
        return this.taskName;
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }
}

