/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import paper.libs.org.eclipse.core.internal.resources.mapping.ModelProviderManager;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.IResourceDelta;
import paper.libs.org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import paper.libs.org.eclipse.core.resources.mapping.ModelStatus;
import paper.libs.org.eclipse.core.resources.mapping.ResourceMapping;
import paper.libs.org.eclipse.core.resources.mapping.ResourceMappingContext;
import paper.libs.org.eclipse.core.resources.mapping.ResourceTraversal;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.PlatformObject;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.SubMonitor;

public abstract class ModelProvider
extends PlatformObject {
    public static final String RESOURCE_MODEL_PROVIDER_ID = "paper.libs.org.eclipse.core.resources.modelProvider";
    private IModelProviderDescriptor descriptor;

    public static IModelProviderDescriptor getModelProviderDescriptor(String id) {
        IModelProviderDescriptor[] descs;
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descs = ModelProviderManager.getDefault().getDescriptors();
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            if (descriptor.getId().equals(id)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    public static IModelProviderDescriptor[] getModelProviderDescriptors() {
        return ModelProviderManager.getDefault().getDescriptors();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelProvider) {
            ModelProvider other = (ModelProvider)obj;
            return other.getDescriptor().getId().equals(this.getDescriptor().getId());
        }
        return super.equals(obj);
    }

    public final IModelProviderDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final String getId() {
        return this.descriptor.getId();
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return new ResourceMapping[0];
    }

    public ResourceMapping[] getMappings(IResource[] resources, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<ResourceMapping> mappings = new HashSet<ResourceMapping>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceMapping[] resourceMappings = this.getMappings(resource, context, monitor);
            if (resourceMappings.length > 0) {
                mappings.addAll(Arrays.asList(resourceMappings));
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public ResourceMapping[] getMappings(ResourceTraversal[] traversals, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            ResourceMapping[] mappings = this.getMappings(traversal.getResources(), context, monitor);
            result.addAll(Arrays.asList(mappings));
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMapping[] mappings, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert(monitor, mappings.length);
        ArrayList traversals = new ArrayList();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Collections.addAll(traversals, mapping.getTraversals(context, subMonitor.newChild(1)));
            ++n2;
        }
        return traversals.toArray(new ResourceTraversal[traversals.size()]);
    }

    public int hashCode() {
        return this.getDescriptor().getId().hashCode();
    }

    public final void init(IModelProviderDescriptor desc) {
        if (this.descriptor != null) {
            return;
        }
        this.descriptor = desc;
        this.initialize();
    }

    protected void initialize() {
    }

    public IStatus validateChange(IResourceDelta delta, IProgressMonitor monitor) {
        return new ModelStatus(0, "paper.libs.org.eclipse.core.resources", this.descriptor.getId(), Status.OK_STATUS.getMessage());
    }
}

