/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.io.InputStream;
import java.net.URI;
import paper.libs.org.eclipse.core.filesystem.EFS;
import paper.libs.org.eclipse.core.filesystem.IFileInfo;
import paper.libs.org.eclipse.core.filesystem.IFileStore;
import paper.libs.org.eclipse.core.filesystem.provider.FileInfo;
import paper.libs.org.eclipse.core.filesystem.provider.FileStore;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.Path;

public class VirtualFileStore
extends FileStore {
    private final URI location;

    public VirtualFileStore(URI location) {
        this.location = location;
    }

    @Override
    public String[] childNames(int options, IProgressMonitor monitor) {
        return FileStore.EMPTY_STRING_ARRAY;
    }

    @Override
    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo result = new FileInfo();
        result.setDirectory(true);
        result.setExists(true);
        result.setLastModified(1L);
        return result;
    }

    @Override
    public void delete(int options, IProgressMonitor monitor) {
    }

    @Override
    public IFileStore getChild(String name2) {
        return EFS.getNullFileSystem().getStore(new Path(name2).makeAbsolute());
    }

    @Override
    public String getName() {
        return "virtual";
    }

    @Override
    public IFileStore getParent() {
        return null;
    }

    @Override
    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        destination.mkdir(0, monitor);
    }

    @Override
    public InputStream openInputStream(int options, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public URI toURI() {
        return this.location;
    }
}

