/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import paper.libs.org.eclipse.core.internal.resources.IMarkerSetElement;
import paper.libs.org.eclipse.core.internal.resources.MarkerAttributeMap;
import paper.libs.org.eclipse.core.internal.utils.IStringPoolParticipant;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.internal.utils.StringPool;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.osgi.util.NLS;

public class MarkerInfo
implements IMarkerSetElement,
Cloneable,
IStringPoolParticipant {
    protected static final Integer INTEGER_ONE = 1;
    protected static final Integer INTEGER_TWO = 2;
    protected static final Integer INTEGER_ZERO = 0;
    protected static final long UNDEFINED_ID = -1L;
    protected Map<String, Object> attributes = null;
    protected long creationTime = 0L;
    protected long id = -1L;
    protected String type = null;

    protected static Object checkValidAttribute(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueString = (String)value;
            if (valueString.length() < 21000) {
                return value;
            }
            byte[] bytes = valueString.getBytes(StandardCharsets.UTF_8);
            if (bytes.length > 65535) {
                String msg = "Marker property value is too long: " + valueString.substring(0, 10000);
                Assert.isTrue(false, msg);
            }
            return value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof Integer) {
            switch ((Integer)value) {
                case 0: {
                    return INTEGER_ZERO;
                }
                case 1: {
                    return INTEGER_ONE;
                }
                case 2: {
                    return INTEGER_TWO;
                }
            }
            return value;
        }
        throw new IllegalArgumentException(NLS.bind(Messages.resources_wrongMarkerAttributeValueType, value.getClass().getName()));
    }

    public Object clone() {
        try {
            MarkerInfo copy = (MarkerInfo)super.clone();
            copy.attributes = this.getAttributes(true);
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getAttribute(String attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public Map<String, Object> getAttributes() {
        return this.getAttributes(true);
    }

    public Map<String, Object> getAttributes(boolean makeCopy) {
        if (this.attributes == null) {
            return null;
        }
        return makeCopy ? new MarkerAttributeMap<Object>(this.attributes) : this.attributes;
    }

    public Object[] getAttributes(String[] attributeNames) {
        Object[] result = new Object[attributeNames.length];
        int i2 = 0;
        while (i2 < attributeNames.length) {
            result[i2] = this.getAttribute(attributeNames[i2]);
            ++i2;
        }
        return result;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void internalSetAttributes(Map<String, Object> map2) {
        this.attributes = map2;
    }

    public void setAttribute(String attributeName, Object value, boolean validate) {
        if (validate) {
            value = MarkerInfo.checkValidAttribute(value);
        }
        if (this.attributes == null) {
            if (value == null) {
                return;
            }
            this.attributes = new MarkerAttributeMap<Object>();
            this.attributes.put(attributeName, value);
        } else if (value == null) {
            this.attributes.remove(attributeName);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(attributeName, value);
        }
    }

    public void setAttributes(Map<String, ? extends Object> map2, boolean validate) {
        if (map2 == null) {
            this.attributes = null;
        } else {
            this.attributes = new MarkerAttributeMap<Object>(map2.size());
            for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
                String key = entry.getKey();
                Assert.isTrue(key instanceof String);
                Object value = entry.getValue();
                this.setAttribute(key, value, validate);
            }
        }
    }

    public void setAttributes(String[] attributeNames, Object[] values, boolean validate) {
        Assert.isTrue(attributeNames.length == values.length);
        int i2 = 0;
        while (i2 < attributeNames.length) {
            this.setAttribute(attributeNames[i2], values[i2], validate);
            ++i2;
        }
    }

    public void setCreationTime(long value) {
        this.creationTime = value;
    }

    public void setId(long value) {
        this.id = value;
    }

    public void setType(String value) {
        this.type = value;
    }

    @Override
    public void shareStrings(StringPool set) {
        this.type = set.add(this.type);
        Map<String, Object> map2 = this.attributes;
        if (map2 instanceof IStringPoolParticipant) {
            ((IStringPoolParticipant)((Object)map2)).shareStrings(set);
        }
    }
}

