/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import paper.libs.org.eclipse.core.internal.localstore.PrefixPool;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.internal.utils.Policy;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.resources.WorkspaceJob;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.MultiStatus;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.SubMonitor;

public class RefreshJob
extends WorkspaceJob {
    private static final long UPDATE_DELAY = 200L;
    private final List<IResource> fRequests = new ArrayList<IResource>(1);
    private PrefixPool pathPrefixHistory;
    private PrefixPool rootPathHistory;

    public RefreshJob() {
        super(Messages.refresh_jobName);
    }

    private synchronized void addRequest(IResource resource) {
        IPath toAdd = resource.getFullPath();
        Iterator<IResource> it = this.fRequests.iterator();
        while (it.hasNext()) {
            IPath request = it.next().getFullPath();
            if (toAdd.isPrefixOf(request)) {
                it.remove();
                continue;
            }
            if (!request.isPrefixOf(toAdd)) continue;
            return;
        }
        this.fRequests.add(resource);
    }

    private synchronized void addRequests(List<IResource> list) {
        this.fRequests.addAll(0, list);
    }

    @Override
    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_REFRESH;
    }

    private List<IResource> collectChildrenToDepth(IResource resource, ArrayList<IResource> children, int depth) {
        IResource[] members;
        if (resource.getType() == 1) {
            return children;
        }
        try {
            members = ((IContainer)resource).members();
        }
        catch (CoreException coreException) {
            return children;
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() != 1) {
                if (depth <= 1) {
                    children.add(member);
                } else {
                    this.collectChildrenToDepth(member, children, depth - 1);
                }
            }
            ++n2;
        }
        return children;
    }

    public PrefixPool getPathPrefixHistory() {
        if (this.pathPrefixHistory == null) {
            this.pathPrefixHistory = new PrefixPool(20);
        }
        return this.pathPrefixHistory;
    }

    public PrefixPool getRootPathHistory() {
        if (this.rootPathHistory == null) {
            this.rootPathHistory = new PrefixPool(20);
        }
        return this.rootPathHistory;
    }

    private synchronized IResource nextRequest() {
        int len = this.fRequests.size();
        if (len == 0) {
            return null;
        }
        return this.fRequests.remove(len - 1);
    }

    public void refresh(IResource resource) {
        if (resource == null) {
            return;
        }
        this.addRequest(resource);
        this.schedule(200L);
    }

    @Override
    public IStatus runInWorkspace(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        String msg = Messages.refresh_refreshErr;
        MultiStatus errors = new MultiStatus("paper.libs.org.eclipse.core.resources", 1, msg, null);
        long longestRefresh = 0L;
        SubMonitor subMonitor = SubMonitor.convert(monitor);
        try {
            IResource toRefresh;
            if (Policy.DEBUG_AUTO_REFRESH) {
                Policy.debug("Auto-refresh:  starting refresh job");
            }
            int refreshCount = 0;
            int depth = 2;
            while ((toRefresh = this.nextRequest()) != null) {
                try {
                    subMonitor.setWorkRemaining(Math.max(this.fRequests.size(), 100));
                    ++refreshCount;
                    long refreshTime = -System.currentTimeMillis();
                    toRefresh.refreshLocal(1000 + depth, subMonitor.split(1));
                    if ((refreshTime += System.currentTimeMillis()) > longestRefresh) {
                        longestRefresh = refreshTime;
                    }
                    if (refreshCount % 1000 == 0) {
                        Thread.yield();
                        if (longestRefresh > 2000L && depth > 1) {
                            depth = 1;
                        }
                        if (longestRefresh < 1000L) {
                            depth *= 2;
                        }
                        longestRefresh = 0L;
                    }
                    this.addRequests(this.collectChildrenToDepth(toRefresh, new ArrayList<IResource>(), depth));
                }
                catch (CoreException e) {
                    errors.merge(new Status(4, "paper.libs.org.eclipse.core.resources", 1, errors.getMessage(), (Throwable)e));
                }
            }
        }
        finally {
            this.pathPrefixHistory = null;
            this.rootPathHistory = null;
            if (Policy.DEBUG_AUTO_REFRESH) {
                Policy.debug("Auto-refresh:  finished refresh job in: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    @Override
    public synchronized boolean shouldRun() {
        return !this.fRequests.isEmpty();
    }

    public void start() {
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  enabling auto-refresh");
        }
    }

    public void stop() {
        if (Policy.DEBUG_AUTO_REFRESH) {
            Policy.debug("Auto-refresh:  disabling auto-refresh");
        }
        this.cancel();
    }
}

