/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.propertytester;

import paper.libs.org.eclipse.core.internal.propertytester.ResourcePropertyTester;
import paper.libs.org.eclipse.core.resources.IProject;
import paper.libs.org.eclipse.core.resources.mapping.ResourceMapping;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.QualifiedName;

public class ResourceMappingPropertyTester
extends ResourcePropertyTester {
    @Override
    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        String expectedVal;
        String propertyName;
        if (!(receiver instanceof ResourceMapping)) {
            return false;
        }
        if (!method.equals("projectPersistentProperty")) {
            return false;
        }
        IProject[] projects = ((ResourceMapping)receiver).getProjects();
        if (projects.length == 0) {
            return false;
        }
        switch (args.length) {
            case 0: {
                propertyName = this.toString(expectedValue);
                expectedVal = null;
                break;
            }
            case 1: {
                propertyName = this.toString(args[0]);
                expectedVal = null;
                break;
            }
            default: {
                propertyName = this.toString(args[0]);
                expectedVal = this.toString(args[1]);
            }
        }
        QualifiedName key = this.toQualifedName(propertyName);
        boolean found = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                String actualVal = project.getPersistentProperty(key);
                if (actualVal != null) {
                    found = true;
                    if (expectedVal != null && !expectedVal.equals(actualVal.toString())) {
                        return false;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return found;
    }
}

