/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.jobs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObjectMap
implements Map {
    protected static final int DEFAULT_SIZE = 16;
    protected static final int GROW_SIZE = 10;
    protected int count = 0;
    protected Object[] elements = null;

    public ObjectMap(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elements = new Object[Math.max(initialCapacity * 2, 0)];
        }
    }

    public ObjectMap(Map map2) {
        this(map2.size());
        this.putAll(map2);
    }

    @Override
    public void clear() {
        this.elements = null;
        this.count = 0;
    }

    public Object clone() {
        return new ObjectMap(this);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.elements == null || this.count == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null && this.elements[i2].equals(key)) {
                return true;
            }
            i2 += 2;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.elements == null || this.count == 0) {
            return false;
        }
        int i2 = 1;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null && this.elements[i2].equals(value)) {
                return true;
            }
            i2 += 2;
        }
        return false;
    }

    public Set entrySet() {
        return this.count == 0 ? Collections.EMPTY_SET : this.toHashMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.count != other.size()) {
            return false;
        }
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null && !this.elements[i2 + 1].equals(other.get(this.elements[i2]))) {
                return false;
            }
            i2 += 2;
        }
        return true;
    }

    public Object get(Object key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null && this.elements[i2].equals(key)) {
                return this.elements[i2 + 1];
            }
            i2 += 2;
        }
        return null;
    }

    protected void grow() {
        Object[] expanded = new Object[this.elements.length + 10];
        System.arraycopy(this.elements, 0, expanded, 0, this.elements.length);
        this.elements = expanded;
    }

    @Override
    public int hashCode() {
        int hash2 = 0;
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null) {
                hash2 += this.elements[i2].hashCode();
            }
            i2 += 2;
        }
        return hash2;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        HashSet<Object> result = new HashSet<Object>(this.size());
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null) {
                result.add(this.elements[i2]);
            }
            i2 += 2;
        }
        return result;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return this.remove(key);
        }
        if (this.elements == null) {
            this.elements = new Object[16];
        }
        if (this.count == 0) {
            this.elements[0] = key;
            this.elements[1] = value;
            ++this.count;
            return null;
        }
        int emptyIndex = -1;
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null) {
                if (this.elements[i2].equals(key)) {
                    Object oldValue = this.elements[i2 + 1];
                    this.elements[i2 + 1] = value;
                    return oldValue;
                }
            } else if (emptyIndex == -1) {
                emptyIndex = i2;
            }
            i2 += 2;
        }
        if (emptyIndex == -1) {
            emptyIndex = this.count * 2;
        }
        if (this.elements.length <= this.count * 2) {
            this.grow();
        }
        this.elements[emptyIndex] = key;
        this.elements[emptyIndex + 1] = value;
        ++this.count;
        return null;
    }

    public void putAll(Map map2) {
        for (Object key : map2.keySet()) {
            Object value = map2.get(key);
            this.put(key, value);
        }
    }

    public Object remove(Object key) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null && this.elements[i2].equals(key)) {
                this.elements[i2] = null;
                Object result = this.elements[i2 + 1];
                this.elements[i2 + 1] = null;
                --this.count;
                return result;
            }
            i2 += 2;
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    private HashMap<Object, Object> toHashMap() {
        HashMap<Object, Object> result = new HashMap<Object, Object>(this.size());
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null) {
                result.put(this.elements[i2], this.elements[i2 + 1]);
            }
            i2 += 2;
        }
        return result;
    }

    public Collection values() {
        HashSet<Object> result = new HashSet<Object>(this.size());
        int i2 = 1;
        while (i2 < this.elements.length) {
            if (this.elements[i2] != null) {
                result.add(this.elements[i2]);
            }
            i2 += 2;
        }
        return result;
    }
}

