/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.expressions;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import paper.libs.org.eclipse.core.expressions.AndExpression;
import paper.libs.org.eclipse.core.expressions.CompositeExpression;
import paper.libs.org.eclipse.core.expressions.CountExpression;
import paper.libs.org.eclipse.core.expressions.ElementHandler;
import paper.libs.org.eclipse.core.expressions.EqualsExpression;
import paper.libs.org.eclipse.core.expressions.Expression;
import paper.libs.org.eclipse.core.expressions.ExpressionConverter;
import paper.libs.org.eclipse.core.expressions.OrExpression;
import paper.libs.org.eclipse.core.expressions.ReferenceExpression;
import paper.libs.org.eclipse.core.expressions.TestExpression;
import paper.libs.org.eclipse.core.expressions.WithExpression;
import paper.libs.org.eclipse.core.internal.expressions.AdaptExpression;
import paper.libs.org.eclipse.core.internal.expressions.EnablementExpression;
import paper.libs.org.eclipse.core.internal.expressions.InstanceofExpression;
import paper.libs.org.eclipse.core.internal.expressions.IterateExpression;
import paper.libs.org.eclipse.core.internal.expressions.NotExpression;
import paper.libs.org.eclipse.core.internal.expressions.ResolveExpression;
import paper.libs.org.eclipse.core.internal.expressions.SystemTestExpression;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;

public class StandardElementHandler
extends ElementHandler {
    @Override
    public Expression create(ExpressionConverter converter, IConfigurationElement element) throws CoreException {
        String name2 = element.getName();
        if (name2 == null) {
            return null;
        }
        switch (name2) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                return new NotExpression(converter.perform(element.getChildren()[0]));
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }

    @Override
    public Expression create(ExpressionConverter converter, Element element) throws CoreException {
        String name2 = element.getNodeName();
        if (name2 == null) {
            return null;
        }
        switch (name2) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        return new NotExpression(converter.perform((Element)child));
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }
}

