/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import paper.libs.org.eclipse.core.internal.events.ResourceDelta;
import paper.libs.org.eclipse.core.internal.events.ResourceDeltaInfo;
import paper.libs.org.eclipse.core.internal.resources.IMarkerSetElement;
import paper.libs.org.eclipse.core.internal.resources.MarkerDelta;
import paper.libs.org.eclipse.core.internal.resources.MarkerSet;
import paper.libs.org.eclipse.core.resources.IMarkerDelta;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.resources.IResourceChangeEvent;
import paper.libs.org.eclipse.core.resources.IResourceDelta;
import paper.libs.org.eclipse.core.runtime.IPath;

public class ResourceChangeEvent
extends EventObject
implements IResourceChangeEvent {
    private static final IMarkerDelta[] NO_MARKER_DELTAS = new IMarkerDelta[0];
    private static final long serialVersionUID = 1L;
    IResourceDelta delta;
    IResource resource;
    private int trigger = 0;
    int type;

    protected ResourceChangeEvent(Object source, int type, IResource resource) {
        super(source);
        this.resource = resource;
        this.type = type;
    }

    public ResourceChangeEvent(Object source, int type, int buildKind, IResourceDelta delta) {
        super(source);
        this.delta = delta;
        this.trigger = buildKind;
        this.type = type;
    }

    @Override
    public IMarkerDelta[] findMarkerDeltas(String findType, boolean includeSubtypes) {
        if (this.delta == null) {
            return NO_MARKER_DELTAS;
        }
        ResourceDeltaInfo info = ((ResourceDelta)this.delta).getDeltaInfo();
        if (info == null) {
            return NO_MARKER_DELTAS;
        }
        Map<IPath, MarkerSet> markerDeltas = info.getMarkerDeltas();
        if (markerDeltas == null || markerDeltas.isEmpty()) {
            return NO_MARKER_DELTAS;
        }
        ArrayList<MarkerDelta> matching = new ArrayList<MarkerDelta>();
        for (MarkerSet deltas : markerDeltas.values()) {
            IMarkerSetElement[] elements;
            IMarkerSetElement[] iMarkerSetElementArray = elements = deltas.elements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerSetElement element = iMarkerSetElementArray[n2];
                MarkerDelta markerDelta = (MarkerDelta)element;
                if (findType == null || (includeSubtypes ? markerDelta.isSubtypeOf(findType) : markerDelta.getType().equals(findType))) {
                    matching.add(markerDelta);
                }
                ++n2;
            }
        }
        return matching.toArray(new IMarkerDelta[matching.size()]);
    }

    @Override
    public int getBuildKind() {
        return this.trigger;
    }

    @Override
    public IResourceDelta getDelta() {
        return this.delta;
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setDelta(IResourceDelta value) {
        this.delta = value;
    }

    public String toDebugString() {
        StringBuilder output = new StringBuilder();
        output.append("\nType: ");
        switch (this.type) {
            case 1: {
                output.append("POST_CHANGE");
                break;
            }
            case 2: {
                output.append("PRE_CLOSE");
                break;
            }
            case 4: {
                output.append("PRE_DELETE");
                break;
            }
            case 8: {
                output.append("PRE_BUILD");
                break;
            }
            case 16: {
                output.append("POST_BUILD");
                break;
            }
            case 32: {
                output.append("PRE_REFRESH");
                break;
            }
            default: {
                output.append("?");
            }
        }
        output.append("\nBuild kind: ");
        switch (this.trigger) {
            case 6: {
                output.append("FULL_BUILD");
                break;
            }
            case 9: 
            case 10: {
                output.append("INCREMENTAL_BUILD");
                break;
            }
            case 15: {
                output.append("CLEAN_BUILD");
                break;
            }
            default: {
                output.append(this.trigger);
            }
        }
        output.append("\nResource: " + (this.resource == null ? "null" : this.resource));
        output.append("\nDelta:" + (this.delta == null ? " null" : ((ResourceDelta)this.delta).toDeepDebugString()));
        return output.toString();
    }
}

