/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import paper.libs.org.eclipse.core.runtime.ServiceCaller;

public final class XMLRootHandler
extends DefaultHandler
implements LexicalHandler {
    private boolean checkRoot;
    private String dtdFound = null;
    private String elementFound = null;
    private String namespaceFound = null;

    public XMLRootHandler(boolean checkRoot) {
        this.checkRoot = checkRoot;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    private SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        return parser;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name2) {
    }

    public String getDTD() {
        return this.dtdFound;
    }

    public String getRootName() {
        return this.elementFound;
    }

    public String getRootNamespace() {
        return this.namespaceFound;
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public boolean parseContents(InputSource contents2) throws IOException, ParserConfigurationException, SAXException {
        return ServiceCaller.callOnce(this.getClass(), SAXParserFactory.class, factory -> {
            try {
                factory.setNamespaceAware(true);
                SAXParser parser = this.createParser((SAXParserFactory)factory);
                contents2.setSystemId("/");
                parser.parse(contents2, (DefaultHandler)this);
            }
            catch (StopParsingException stopParsingException) {
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                XMLRootHandler.sneakyThrow(e);
            }
        });
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name2, String publicId, String systemId) throws SAXException {
        this.dtdFound = systemId;
        if (!this.checkRoot) {
            throw new StopParsingException();
        }
    }

    @Override
    public void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
        this.elementFound = elementName;
        this.namespaceFound = uri;
        throw new StopParsingException();
    }

    @Override
    public void startEntity(String name2) {
    }

    private static class StopParsingException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public StopParsingException() {
            super((String)null);
        }
    }
}

