/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import paper.libs.org.eclipse.core.internal.content.Util;
import paper.libs.org.eclipse.core.runtime.QualifiedName;
import paper.libs.org.eclipse.core.runtime.content.IContentDescription;
import paper.libs.org.eclipse.core.runtime.content.ITextContentDescriber;

public class TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    @Override
    public int describe(Reader contents2, IContentDescription description) throws IOException {
        return 1;
    }

    @Override
    public int describe(InputStream contents2, IContentDescription description) throws IOException {
        if (description == null || !description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            return 1;
        }
        byte[] bom = Util.getByteOrderMark(contents2);
        if (bom != null) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, bom);
        }
        return 1;
    }

    @Override
    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

