/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.type;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.bombe.type.MethodDescriptorReader;
import paper.libs.org.cadixdev.bombe.type.Type;

public final class MethodDescriptor {
    private final List<FieldType> paramTypes;
    private final Type returnType;

    public static MethodDescriptor of(String descriptor) {
        return new MethodDescriptorReader(descriptor).read();
    }

    public static MethodDescriptor of(Method method) {
        return new MethodDescriptor(Arrays.stream(method.getParameterTypes()).map(FieldType::of).collect(Collectors.toList()), Type.of(method.getReturnType()));
    }

    public MethodDescriptor(List<FieldType> paramTypes, Type returnType) {
        this.paramTypes = paramTypes;
        this.returnType = returnType;
    }

    public List<FieldType> getParamTypes() {
        return Collections.unmodifiableList(this.paramTypes);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuilder typeBuilder = new StringBuilder();
        typeBuilder.append("(");
        this.paramTypes.forEach(type -> typeBuilder.append(type.toString()));
        typeBuilder.append(")");
        typeBuilder.append(this.returnType.toString());
        return typeBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)obj;
        return Objects.equals(this.paramTypes, that.paramTypes) && Objects.equals(this.returnType, that.returnType);
    }

    public int hashCode() {
        return Objects.hash(this.paramTypes, this.returnType);
    }
}

