/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.bombe.asm.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import paper.libs.org.cadixdev.bombe.asm.jar.ClassProvider;
import paper.libs.org.cadixdev.bombe.util.ByteStreams;

public class JarFileClassProvider
implements ClassProvider {
    private final JarFile jar;

    public JarFileClassProvider(JarFile jar2) {
        this.jar = jar2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] get(String klass) {
        String internalName = klass + ".class";
        JarEntry entry = this.jar.getJarEntry(internalName);
        if (entry == null) {
            return null;
        }
        try (InputStream in = this.jar.getInputStream(entry);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteStreams.copy(in, baos);
            byte[] byArray2 = baos.toByteArray();
            return byArray2;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

