/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.atlas;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import paper.libs.org.cadixdev.atlas.AtlasTransformerContext;
import paper.libs.org.cadixdev.atlas.jar.JarFile;
import paper.libs.org.cadixdev.atlas.util.CascadingClassProvider;
import paper.libs.org.cadixdev.atlas.util.JarRepacker;
import paper.libs.org.cadixdev.bombe.asm.analysis.ClassProviderInheritanceProvider;
import paper.libs.org.cadixdev.bombe.asm.jar.ClassProvider;
import paper.libs.org.cadixdev.bombe.jar.JarEntryTransformer;

public class Atlas
implements Closeable {
    private final List<Function<AtlasTransformerContext, JarEntryTransformer>> transformers = new ArrayList<Function<AtlasTransformerContext, JarEntryTransformer>>();
    private final List<JarFile> classpath = new ArrayList<JarFile>();
    private final ExecutorService executorService;
    private final boolean manageExecutor;

    private Atlas(ExecutorService executorService, boolean manageExecutor) {
        this.executorService = executorService;
        this.manageExecutor = manageExecutor;
    }

    public Atlas(ExecutorService executorService) {
        this(executorService, false);
    }

    public Atlas(int parallelism) {
        this(Executors.newWorkStealingPool(parallelism), true);
    }

    public Atlas() {
        this(Executors.newWorkStealingPool(), true);
    }

    public Atlas use(Path jar2) throws IOException {
        this.classpath.add(new JarFile(jar2));
        return this;
    }

    public Atlas install(Function<AtlasTransformerContext, JarEntryTransformer> transformer) {
        this.transformers.add(transformer);
        return this;
    }

    public void run(Path input, Path output) throws IOException {
        try (JarFile jar2 = new JarFile(input);){
            this.run(jar2, output);
        }
    }

    public void run(JarFile jar2, Path output) throws IOException {
        ArrayList<ClassProvider> classpath = new ArrayList<ClassProvider>();
        classpath.add(jar2);
        classpath.addAll(this.classpath);
        AtlasTransformerContext context = new AtlasTransformerContext(new ClassProviderInheritanceProvider(new CascadingClassProvider(classpath)));
        JarEntryTransformer[] transformers = (JarEntryTransformer[])this.transformers.stream().map(constructor -> (JarEntryTransformer)constructor.apply(context)).toArray(JarEntryTransformer[]::new);
        jar2.transform(output, this.executorService, transformers);
        JarRepacker.verifyJarManifest(output);
    }

    @Override
    public void close() throws IOException {
        if (this.manageExecutor) {
            this.executorService.shutdown();
        }
        for (JarFile jar2 : this.classpath) {
            jar2.close();
        }
        this.classpath.clear();
    }
}

