/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.at.io.fml;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import paper.libs.org.cadixdev.at.AccessChange;
import paper.libs.org.cadixdev.at.AccessTransform;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.ModifierChange;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;

final class FmlReader {
    private static final char COMMENT_PREFIX = '#';
    private static final char WILDCARD = '*';
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    static void read(BufferedReader reader, AccessTransformSet set) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = FmlReader.substringBefore(line, '#').trim()).isEmpty()) continue;
            String[] parts = SPACE_PATTERN.split(line);
            if (parts.length != 2 && parts.length != 3) {
                throw new IllegalArgumentException("Invalid FML access transformer line: " + line);
            }
            AccessTransform transform = FmlReader.parseAccessTransform(parts[0]);
            AccessTransformSet.Class classSet = set.getOrCreateClass(parts[1]);
            if (parts.length == 2) {
                classSet.merge(transform);
                continue;
            }
            String name2 = parts[2];
            int methodIndex = name2.indexOf(40);
            if (name2.charAt(0) == '*') {
                if (methodIndex != -1) {
                    classSet.mergeAllMethods(transform);
                    continue;
                }
                classSet.mergeAllFields(transform);
                continue;
            }
            if (methodIndex >= 0) {
                classSet.mergeMethod(MethodSignature.of(name2.substring(0, methodIndex), name2.substring(methodIndex)), transform);
                continue;
            }
            classSet.mergeField(name2, transform);
        }
    }

    private static AccessTransform parseAccessTransform(String access) {
        ModifierChange finalChange;
        int last = access.length() - 1;
        if (last < 2) {
            throw new IllegalArgumentException("Invalid access transformer: " + access);
        }
        if (access.charAt(last) == 'f') {
            finalChange = FmlReader.parseFinalModifier(access.charAt(--last));
            access = access.substring(0, last);
        } else {
            finalChange = ModifierChange.NONE;
        }
        return AccessTransform.of(FmlReader.parseAccess(access), finalChange);
    }

    private static AccessChange parseAccess(String access) {
        switch (access) {
            case "public": {
                return AccessChange.PUBLIC;
            }
            case "protected": {
                return AccessChange.PROTECTED;
            }
            case "default": {
                return AccessChange.PACKAGE_PRIVATE;
            }
            case "private": {
                return AccessChange.PRIVATE;
            }
            case "": {
                return AccessChange.NONE;
            }
        }
        throw new IllegalArgumentException("Invalid access modifier: " + access);
    }

    private static ModifierChange parseFinalModifier(char m) {
        switch (m) {
            case '-': {
                return ModifierChange.REMOVE;
            }
            case '+': {
                return ModifierChange.ADD;
            }
        }
        throw new IllegalArgumentException("Invalid final modifier: '" + m);
    }

    private static String substringBefore(String s, char c) {
        int pos = s.indexOf(c);
        return pos >= 0 ? s.substring(0, pos) : s;
    }

    private FmlReader() {
    }
}

