/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.net.fabricmc.lorenztiny;

import java.util.HashMap;
import paper.libs.net.fabricmc.mapping.tree.ClassDef;
import paper.libs.net.fabricmc.mapping.tree.FieldDef;
import paper.libs.net.fabricmc.mapping.tree.MethodDef;
import paper.libs.net.fabricmc.mapping.tree.TinyTree;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.MappingsReader;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;

public class TinyMappingsJoiner
extends MappingsReader {
    private final TinyTree treeA;
    private final String from;
    private final String matchA;
    private final TinyTree treeB;
    private final String to;
    private final String matchB;

    public TinyMappingsJoiner(TinyTree treeA, String from, String matchA, TinyTree treeB, String to, String matchB) {
        this.treeA = treeA;
        this.from = from;
        this.matchA = matchA;
        this.treeB = treeB;
        this.to = to;
        this.matchB = matchB;
    }

    public TinyMappingsJoiner(TinyTree treeA, String from, TinyTree treeB, String to, String match) {
        this(treeA, from, match, treeB, to, match);
    }

    @Override
    public MappingSet read(MappingSet mappings) {
        HashMap<String, ClassDef> classes = new HashMap<String, ClassDef>();
        HashMap<String, FieldDef> fields = new HashMap<String, FieldDef>();
        HashMap<String, MethodDef> methods = new HashMap<String, MethodDef>();
        for (ClassDef klass : this.treeB.getClasses()) {
            classes.put(klass.getName(this.matchA), klass);
            for (FieldDef field : klass.getFields()) {
                fields.put(field.getName(this.matchA), field);
            }
            for (MethodDef method : klass.getMethods()) {
                methods.put(method.getName(this.matchA), method);
            }
        }
        for (ClassDef classA : this.treeA.getClasses()) {
            ClassDef classB = (ClassDef)classes.get(classA.getName(this.matchB));
            ClassMapping<?, ?> klass = mappings.getOrCreateClassMapping(classA.getName(this.from));
            if (classB != null) {
                klass.setDeobfuscatedName(classB.getName(this.to));
            }
            for (FieldDef fieldA : classA.getFields()) {
                FieldDef fieldB = (FieldDef)fields.get(fieldA.getName(this.matchB));
                if (fieldB == null) continue;
                klass.getOrCreateFieldMapping(fieldA.getName(this.from), fieldA.getDescriptor(this.from)).setDeobfuscatedName(fieldB.getName(this.to));
            }
            for (MethodDef methodA : classA.getMethods()) {
                MethodDef methodB = (MethodDef)methods.get(methodA.getName(this.matchB));
                if (methodB == null) continue;
                klass.getOrCreateMethodMapping(methodA.getName(this.from), methodA.getDescriptor(this.from)).setDeobfuscatedName(methodB.getName(this.to));
            }
        }
        return mappings;
    }

    @Override
    public void close() {
    }
}

