/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.data.MemberData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.dev.denwav.hypo.model.data.types.JvmType;
import paper.libs.dev.denwav.hypo.model.data.types.PrimitiveType;

public interface MethodData
extends MemberData {
    @NotNull
    public MethodDescriptor descriptor();

    @NotNull
    default public String descriptorText() {
        return this.descriptor().toInternalString();
    }

    public boolean isAbstract();

    public boolean isBridge();

    public boolean isNative();

    default public boolean isConstructor() {
        return false;
    }

    @NotNull
    default public @NotNull List<@NotNull JvmType> params() {
        return this.descriptor().getParams();
    }

    @NotNull
    default public JvmType param(int i2) {
        List<@NotNull JvmType> params = this.descriptor().getParams();
        if (i2 < 0 || i2 >= params.size()) {
            throw new IndexOutOfBoundsException("Index out of range: " + i2 + ", list has " + params.size() + " items");
        }
        return params.get(i2);
    }

    @Nullable
    default public JvmType paramLvt(int i2) {
        List<@NotNull JvmType> params = this.descriptor().getParams();
        int index = this.isStatic() ? 0 : 1;
        for (JvmType param : params) {
            if (index == i2) {
                return param;
            }
            ++index;
            if (param != PrimitiveType.LONG && param != PrimitiveType.DOUBLE) continue;
            ++index;
        }
        return null;
    }

    @NotNull
    default public JvmType returnType() {
        return this.descriptor().getReturnType();
    }

    default public boolean overrides(@NotNull MethodData that) {
        if (this.isStatic() || that.isStatic() || that.isFinal()) {
            return false;
        }
        if (!this.visibility().canOverride(that.visibility())) {
            return false;
        }
        if (that.visibility() == Visibility.PACKAGE) {
            int thatLastIndex;
            String thisClassName = this.parentClass().name();
            String thatClassName = that.parentClass().name();
            int thisLastIndex = thisClassName.lastIndexOf(47);
            if (thisLastIndex != (thatLastIndex = thatClassName.lastIndexOf(47))) {
                return false;
            }
            if (!thisClassName.regionMatches(0, thatClassName, 0, thatLastIndex)) {
                return false;
            }
        }
        if (!this.name().equals(that.name())) {
            return false;
        }
        if (!this.descriptor().equals(that.descriptor())) {
            return false;
        }
        return this.parentClass().doesExtendOrImplement(that.parentClass());
    }

    public void setSuperMethod(@Nullable MethodData var1);

    @Nullable
    public MethodData superMethod();

    @NotNull
    public Set<MethodData> childMethods();
}

