/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model.data;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.HypoData;
import paper.libs.dev.denwav.hypo.model.data.HypoKey;

public abstract class AbstractHypoData
implements HypoData {
    @NotNull
    private final Map<HypoKey<?>, ?> hypoData = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    @Nullable
    public <T> T store(@NotNull HypoKey<T> key, @Nullable T t) {
        if (t == null) {
            this.hypoData.remove(key);
        } else {
            this.hypoData.put(key, HypoModelUtil.cast(t));
        }
        return t;
    }

    @Override
    @NotNull
    public <T> T compute(@NotNull HypoKey<T> key, @NotNull Supplier<T> supplier) {
        Object o = this.hypoData.computeIfAbsent(key, k -> HypoModelUtil.cast(supplier.get()));
        Objects.requireNonNull(o, "Result of supplier must not be null");
        return HypoModelUtil.cast(o);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull HypoKey<T> key) {
        return HypoModelUtil.cast(this.hypoData.get(key));
    }

    @Override
    public boolean contains(@NotNull HypoKey<?> key) {
        return this.hypoData.containsKey(key);
    }
}

