/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.model;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.dev.denwav.hypo.model.PathClassDataReference;

final class DirClassProviderRoot
implements ClassProviderRoot {
    @NotNull
    private final Path root;

    DirClassProviderRoot(@NotNull Path root) {
        this.root = root;
    }

    @Override
    public byte @Nullable [] getClassData(@NotNull String fileName) throws IOException {
        Path file = this.root.resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.readAllBytes(file);
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends ClassProviderRoot.ClassDataReference> getAllClasses() throws IOException {
        List result;
        PathMatcher pathMatcher = this.root.getFileSystem().getPathMatcher("glob:*.class");
        try (Stream<Path> stream = Files.walk(this.root, new FileVisitOption[0]);){
            result = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> pathMatcher.matches(p.getFileName())).map(p -> new PathClassDataReference(this.root.relativize((Path)p).toString(), (Path)p)).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public void close() {
    }
}

