/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.google.errorprone.annotations.CheckReturnValue;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;

public final class MergeResult<T extends MergeableMappingsChange<T>> {
    @Nullable
    private final T merged;
    @Nullable
    private final String errorMessage;

    private MergeResult(@Nullable T merged, @Nullable String errorMessage) {
        this.merged = merged;
        this.errorMessage = errorMessage;
    }

    @CheckReturnValue
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T extends MergeableMappingsChange<T>> MergeResult<T> success(@NotNull T merged) {
        return new MergeResult<T>(merged, null);
    }

    @CheckReturnValue
    @Contract(value="_ -> new", pure=true)
    public static <T extends MergeableMappingsChange<T>> MergeResult<T> failure(@NotNull String errorMessage) {
        return new MergeResult<Object>(null, errorMessage);
    }

    @NotNull
    public T getMerged() {
        return (T)((MergeableMappingsChange)Objects.requireNonNull(this.merged, "Failed merge result"));
    }

    @NotNull
    public String getErrorMessage() {
        return Objects.requireNonNull(this.errorMessage, "Succeeded merge result");
    }

    public boolean isSuccess() {
        return this.merged != null;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeResult that = (MergeResult)o;
        return Objects.equals(this.merged, that.merged) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.merged, this.errorMessage);
    }

    public String toString() {
        return "ChangeResult{merged=" + this.merged + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

