/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.PathJsonConverter;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.gradle.api.Action;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileContents;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.kotlin.dsl.NamedDomainObjectContainerExtensionsKt;
import org.gradle.kotlin.dsl.RegisteringDomainObjectDelegateProviderWithType;
import org.gradle.kotlin.dsl.RegisteringDomainObjectDelegateProviderWithTypeAndAction;
import org.gradle.kotlin.dsl.TaskContainerExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.GsonBuilder;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.org.cadixdev.lorenz.merge.MergeResult;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\"\u001a\u00020#\u001a\u0014\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0\u0005\"\u0004\b\u0000\u0010\u001e\u001a\u001f\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'\"\u00020(\u00a2\u0006\u0002\u0010)\u001a\u001f\u0010*\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'\"\u00020(\u00a2\u0006\u0002\u0010)\u001a\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e\u001a\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202\u001a\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206\u001a\u0012\u00107\u001a\u000208*\u00020\u000f2\u0006\u00109\u001a\u000204\u001aE\u0010:\u001a\b\u0012\u0004\u0012\u0002H\u001e0;\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020<*\u00020=2\u0006\u0010>\u001a\u0002042\u0019\b\b\u0010?\u001a\u0013\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020%0@\u00a2\u0006\u0002\bAH\u0086\b\u00f8\u0001\u0000\u001a@\u0010B\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0013\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020(*\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0014\b\u0004\u0010E\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002H\u001e0@H\u0086\b\u00f8\u0001\u0000\u001a \u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u0013*\u00020(2\u0006\u0010H\u001a\u00020\u000f2\u0006\u0010I\u001a\u00020J\u001a\n\u0010K\u001a\u00020\u000e*\u00020(\u001a\u000e\u0010L\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010(\u001a\n\u0010M\u001a\u00020N*\u00020(\u001a\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u0013*\u00020Q2\u0006\u0010R\u001a\u00020\u0015\u001a\n\u0010S\u001a\u00020D*\u00020T\u001a\u0012\u0010S\u001a\u00020D*\u00020T2\u0006\u0010U\u001a\u000204\u001a\u001a\u0010S\u001a\u00020D*\u00020T2\u0006\u0010>\u001a\u0002042\u0006\u0010U\u001a\u000204\u001a.\u0010V\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u001e0\u0013\"\b\b\u0000\u0010\u001e*\u00020W*\n\u0012\u0006\b\u0001\u0012\u0002H\u001e0\u00132\u0006\u0010R\u001a\u00020\u0015\u001a\"\u0010X\u001a\u0002H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u0001*\u00020\b2\u0006\u0010Y\u001a\u00020(H\u0086\b\u00a2\u0006\u0002\u0010Z\u001a\n\u0010[\u001a\u00020%*\u00020\u000f\u001a'\u0010\\\u001a\b\u0012\u0004\u0012\u0002H\u001e0;\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020<*\u00020=2\u0006\u0010>\u001a\u000204H\u0086\b\u001a'\u0010]\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020=\u0012\u0004\u0012\u0002H\u001e0^\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020<*\u00020=H\u0086\b\u001aE\u0010]\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020=\u0012\u0004\u0012\u0002H\u001e0_\"\n\b\u0000\u0010\u001e\u0018\u0001*\u00020<*\u00020=2\u0019\b\b\u0010`\u001a\u0013\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020%0@\u00a2\u0006\u0002\bAH\u0086\b\u00f8\u0001\u0000\u001a\u0010\u0010a\u001a\b\u0012\u0004\u0012\u00020c0b*\u00020d\u001a\u001d\u0010e\u001a\u0002Hf\"\f\b\u0000\u0010f*\u0006\u0012\u0002\b\u00030g*\u0002Hf\u00a2\u0006\u0002\u0010h\u001a\u001d\u0010i\u001a\u0002Hf\"\f\b\u0000\u0010f*\u0006\u0012\u0002\b\u00030g*\u0002Hf\u00a2\u0006\u0002\u0010h\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00158F\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\"#\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006j"}, d2={"digestSha256", "Ljava/security/MessageDigest;", "getDigestSha256", "()Ljava/security/MessageDigest;", "emptyMergeResult", "Lpaper/libs/org/cadixdev/lorenz/merge/MergeResult;", "", "gson", "Lpaper/libs/com/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "threadLocalDigestSha256", "Ljava/lang/ThreadLocal;", "cache", "Ljava/nio/file/Path;", "Lorg/gradle/api/file/ProjectLayout;", "getCache", "(Lorg/gradle/api/file/ProjectLayout;)Ljava/nio/file/Path;", "download", "Lorg/gradle/api/provider/Provider;", "Lio/papermc/paperweight/DownloadService;", "Lorg/gradle/api/Project;", "getDownload$annotations", "(Lorg/gradle/api/Project;)V", "getDownload", "(Lorg/gradle/api/Project;)Lorg/gradle/api/provider/Provider;", "isBaseExecution", "", "(Lorg/gradle/api/Project;)Z", "orNull", "T", "Ljava/util/Optional;", "getOrNull", "(Ljava/util/Optional;)Ljava/lang/Object;", "commentRegex", "Lkotlin/text/Regex;", "ensureDeleted", "", "files", "", "", "([Ljava/lang/Object;)V", "ensureParentExists", "findOutputDir", "baseFile", "redirect", "Ljava/lang/Thread;", "input", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "toHex", "", "hash", "", "cacheDir", "Lorg/gradle/api/file/Directory;", "path", "configureTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "Lorg/gradle/api/tasks/TaskContainer;", "name", "configure", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "contents", "contentFile", "Lorg/gradle/api/file/RegularFileProperty;", "convert", "convertToFileProvider", "Lorg/gradle/api/file/RegularFile;", "layout", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "convertToPath", "convertToPathOrNull", "convertToUrl", "Ljava/net/URL;", "defaultJavaLauncher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "Lorg/gradle/jvm/toolchain/JavaToolchainService;", "project", "defaultOutput", "Lio/papermc/paperweight/tasks/BaseTask;", "ext", "fileExists", "Lorg/gradle/api/file/FileSystemLocation;", "fromJson", "any", "(Lcom/google/gson/Gson;Ljava/lang/Object;)Ljava/lang/Object;", "initSubmodules", "providerFor", "registering", "Lorg/gradle/kotlin/dsl/RegisteringDomainObjectDelegateProviderWithType;", "Lorg/gradle/kotlin/dsl/RegisteringDomainObjectDelegateProviderWithTypeAndAction;", "configuration", "toJarClassProviderRoots", "", "Lpaper/libs/dev/denwav/hypo/model/ClassProviderRoot;", "Lorg/gradle/api/file/FileCollection;", "withDisallowChanges", "P", "Lorg/gradle/api/provider/Property;", "(Lorg/gradle/api/provider/Property;)Lorg/gradle/api/provider/Property;", "withDisallowUnsafeRead", "paperweight-lib"})
public final class UtilsKt {
    @NotNull
    private static final Gson gson;
    private static final MergeResult emptyMergeResult;
    private static final ThreadLocal<MessageDigest> threadLocalDigestSha256;

    @NotNull
    public static final Gson getGson() {
        return gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final /* synthetic */ <T> T fromJson(Gson $this$fromJson, Object any) {
        Object t;
        int $i$f$fromJson = 0;
        Intrinsics.checkNotNullParameter((Object)$this$fromJson, (String)"$this$fromJson");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        Object object = any;
        if (object instanceof String) {
            Type type;
            Gson $receiver$iv = $this$fromJson;
            String string = (String)any;
            Gson gson = $receiver$iv;
            Intrinsics.needClassReification();
            Type type2 = new TypeToken<T>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv = type2;
            if (type$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv);
            }
            Type type4 = type;
            Object t2 = gson.fromJson(string, type4);
            t = t2;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
        } else {
            Object object2 = UtilsKt.convertToPath(any);
            Charset charset = Charsets.UTF_8;
            OpenOption[] type$iv$iv = new OpenOption[]{};
            int n = 8192;
            boolean bl = false;
            object2 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object2, Arrays.copyOf(type$iv$iv, type$iv$iv.length)), charset), n);
            boolean bl2 = false;
            n = 0;
            Throwable throwable = null;
            try {
                Type type;
                BufferedReader it = (BufferedReader)object2;
                boolean bl3 = false;
                Gson $receiver$iv = $this$fromJson;
                Reader reader = it;
                Gson gson = $receiver$iv;
                Intrinsics.needClassReification();
                Type type5 = new TypeToken<T>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv2 = type5;
                if (type$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv2)) {
                    Type type6 = ((ParameterizedType)type$iv$iv2).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv2);
                }
                Type type7 = type;
                Object t3 = gson.fromJson(reader, type7);
                Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                Object t4 = t3;
                t = t4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
        }
        return t;
    }

    @NotNull
    public static final Path getCache(@NotNull ProjectLayout $this$cache) {
        Intrinsics.checkNotNullParameter((Object)$this$cache, (String)"$this$cache");
        Directory directory = $this$cache.getProjectDirectory().dir(".gradle/caches");
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"projectDirectory.dir(\".gradle/$CACHE_PATH\")");
        return FileKt.getPath((FileSystemLocation)directory);
    }

    @NotNull
    public static final Directory cacheDir(@NotNull ProjectLayout $this$cacheDir, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$cacheDir, (String)"$this$cacheDir");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Directory directory = $this$cacheDir.getProjectDirectory().dir(".gradle/caches").dir(path);
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"projectDirectory.dir(\".g\u2026e/$CACHE_PATH\").dir(path)");
        return directory;
    }

    public static final void initSubmodules(@NotNull ProjectLayout $this$initSubmodules) {
        Intrinsics.checkNotNullParameter((Object)$this$initSubmodules, (String)"$this$initSubmodules");
        Git.Companion.checkForGit();
        Directory directory = $this$initSubmodules.getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"projectDirectory");
        new Git(FileKt.getPath((FileSystemLocation)directory), null, 2, null).invoke("submodule", "update", "--init").executeOut();
    }

    @NotNull
    public static final <T extends FileSystemLocation> Provider<? extends T> fileExists(@NotNull Provider<? extends T> $this$fileExists, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$fileExists, (String)"$this$fileExists");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = $this$fileExists.flatMap(new Transformer(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final Provider<? extends T> transform(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$project.provider(new Callable((FileSystemLocation)it){
                    final /* synthetic */ FileSystemLocation $it;

                    @Nullable
                    public final T call() {
                        FileSystemLocation fileSystemLocation = this.$it;
                        boolean bl = false;
                        boolean bl2 = false;
                        FileSystemLocation f = fileSystemLocation;
                        boolean bl3 = false;
                        FileSystemLocation fileSystemLocation2 = f;
                        Intrinsics.checkNotNullExpressionValue((Object)fileSystemLocation2, (String)"f");
                        Path path = FileKt.getPath(fileSystemLocation2);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        boolean bl4 = false;
                        return (T)(Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? fileSystemLocation : null);
                    }
                    {
                        this.$it = fileSystemLocation;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"flatMap { project.provid\u2026 -> f.path.exists() } } }");
        return provider;
    }

    public static final /* synthetic */ <T extends Task> TaskProvider<T> providerFor(TaskContainer $this$providerFor, String name2) {
        TaskProvider taskProvider;
        int $i$f$providerFor = 0;
        Intrinsics.checkNotNullParameter((Object)$this$providerFor, (String)"$this$providerFor");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if ($this$providerFor.getNames().contains(name2)) {
            TaskCollection $this$named$iv = (TaskCollection)$this$providerFor;
            boolean $i$f$named = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            taskProvider = TaskContainerExtensionsKt.named((TaskCollection)$this$named$iv, (String)name2, (KClass)Reflection.getOrCreateKotlinClass(Task.class));
        } else {
            TaskContainer $this$register$iv = $this$providerFor;
            boolean $i$f$register = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            TaskProvider taskProvider2 = $this$register$iv.register(name2, Task.class);
            taskProvider = taskProvider2;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(name, T::class.java)");
        }
        return taskProvider;
    }

    public static final /* synthetic */ <T extends Task> TaskProvider<T> configureTask(TaskContainer $this$configureTask, String name2, Function1<? super T, Unit> configure2) {
        TaskProvider taskProvider;
        int $i$f$configureTask = 0;
        Intrinsics.checkNotNullParameter((Object)$this$configureTask, (String)"$this$configureTask");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        if ($this$configureTask.getNames().contains(name2)) {
            TaskCollection $this$named$iv = (TaskCollection)$this$configureTask;
            boolean $i$f$named = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Function1<? super T, Unit> function1 = configure2;
            TaskProvider taskProvider2 = $this$named$iv.named(name2, Task.class, new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void execute(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            });
            taskProvider = taskProvider2;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"(this as TaskCollection<\u2026lass.java, configuration)");
        } else {
            TaskContainer $this$register$iv = $this$configureTask;
            boolean $i$f$register = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Function1<? super T, Unit> function1 = configure2;
            TaskProvider taskProvider3 = $this$register$iv.register(name2, Task.class, new /* invalid duplicate definition of identical inner class */);
            taskProvider = taskProvider3;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"register(name, T::class.java, configuration)");
        }
        return taskProvider;
    }

    public static /* synthetic */ void getDownload$annotations(Project project) {
    }

    @NotNull
    public static final Provider<DownloadService> getDownload(@NotNull Project $this$download) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"$this$download");
        Gradle gradle = $this$download.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
        BuildServiceRegistry buildServiceRegistry = gradle.getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"gradle.sharedServices");
        Object object = buildServiceRegistry.getRegistrations().getByName("download");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gradle.sharedServices.re\u2026ons.getByName(\"download\")");
        Provider provider = ((BuildServiceRegistration)object).getService();
        if (provider == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.provider.Provider<io.papermc.paperweight.DownloadService>");
        }
        return provider;
    }

    @NotNull
    public static final Regex commentRegex() {
        return new Regex("\\s*#.*");
    }

    public static final boolean isBaseExecution(@NotNull Project $this$isBaseExecution) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseExecution, (String)"$this$isBaseExecution");
        Object object = $this$isBaseExecution.getProviders().gradleProperty("paperweightDownstreamDataFile").forUseAtConfigurationTime().orElse($this$isBaseExecution.provider((Callable)isBaseExecution.1.INSTANCE)).map((Transformer)isBaseExecution.2.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"providers.gradleProperty\u2026 \"false\" }\n        .get()");
        return (Boolean)object;
    }

    @NotNull
    public static final Thread redirect(@NotNull InputStream input, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Thread thread = new Thread(new Runnable(input, out){
            final /* synthetic */ InputStream $input;
            final /* synthetic */ OutputStream $out;

            public final void run() {
                try {
                    ByteStreamsKt.copyTo$default((InputStream)this.$input, (OutputStream)this.$out, (int)0, (int)2, null);
                }
                catch (Exception e) {
                    throw (Throwable)new PaperweightException("", e);
                }
            }
            {
                this.$input = inputStream;
                this.$out = outputStream;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        Thread $this$apply = thread;
        boolean bl3 = false;
        $this$apply.setDaemon(true);
        $this$apply.start();
        return thread;
    }

    @NotNull
    public static final Path convertToPath(@NotNull Object $this$convertToPath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$convertToPath, (String)"$this$convertToPath");
        Object object = $this$convertToPath;
        if (object instanceof Path) {
            path = (Path)$this$convertToPath;
        } else if (object instanceof File) {
            Path path2 = ((File)$this$convertToPath).toPath();
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.toPath()");
        } else if (object instanceof FileSystemLocation) {
            path = FileKt.getPath((FileSystemLocation)$this$convertToPath);
        } else if (object instanceof Provider) {
            Object object2 = ((Provider)$this$convertToPath).get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.get()");
            path = UtilsKt.convertToPath(object2);
        } else {
            throw (Throwable)new PaperweightException("Unknown type representing a file: " + $this$convertToPath.getClass().getName());
        }
        return path;
    }

    @NotNull
    public static final Provider<RegularFile> convertToFileProvider(@NotNull Object $this$convertToFileProvider, @NotNull ProjectLayout layout, @NotNull ProviderFactory providers) {
        Provider provider;
        Intrinsics.checkNotNullParameter((Object)$this$convertToFileProvider, (String)"$this$convertToFileProvider");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        Object object = $this$convertToFileProvider;
        if (object instanceof Path) {
            Provider provider2 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;

                public final File call() {
                    return ((Path)this.$this_convertToFileProvider).toFile();
                }
                {
                    this.$this_convertToFileProvider = object;
                }
            }));
            provider = provider2;
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"layout.file(providers.provider { toFile() })");
        } else if (object instanceof File) {
            Provider provider3 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;

                public final File call() {
                    return (File)this.$this_convertToFileProvider;
                }
                {
                    this.$this_convertToFileProvider = object;
                }
            }));
            provider = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"layout.file(providers.provider { this })");
        } else if (object instanceof FileSystemLocation) {
            Provider provider4 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;

                public final File call() {
                    return ((FileSystemLocation)this.$this_convertToFileProvider).getAsFile();
                }
                {
                    this.$this_convertToFileProvider = object;
                }
            }));
            provider = provider4;
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"layout.file(providers.provider { asFile })");
        } else if (object instanceof Provider) {
            Provider provider5 = ((Provider)$this$convertToFileProvider).flatMap(new Transformer(layout, providers){
                final /* synthetic */ ProjectLayout $layout;
                final /* synthetic */ ProviderFactory $providers;

                @NotNull
                public final Provider<? extends RegularFile> transform(@NotNull Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return UtilsKt.convertToFileProvider(it, this.$layout, this.$providers);
                }
                {
                    this.$layout = projectLayout;
                    this.$providers = providerFactory;
                }
            });
            provider = provider5;
            Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"flatMap { it.convertToFi\u2026ider(layout, providers) }");
        } else {
            throw (Throwable)new PaperweightException("Unknown type representing a file: " + $this$convertToFileProvider.getClass().getName());
        }
        return provider;
    }

    @Nullable
    public static final Path convertToPathOrNull(@Nullable Object $this$convertToPathOrNull) {
        if ($this$convertToPathOrNull == null) {
            return null;
        }
        return UtilsKt.convertToPath($this$convertToPathOrNull);
    }

    @NotNull
    public static final URL convertToUrl(@NotNull Object $this$convertToUrl) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)$this$convertToUrl, (String)"$this$convertToUrl");
        Object object = $this$convertToUrl;
        if (object instanceof URL) {
            uRL = (URL)$this$convertToUrl;
        } else if (object instanceof URI) {
            URL uRL2 = ((URI)$this$convertToUrl).toURL();
            uRL = uRL2;
            Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"this.toURL()");
        } else if (object instanceof String) {
            URL uRL3 = URI.create((String)$this$convertToUrl).toURL();
            uRL = uRL3;
            Intrinsics.checkNotNullExpressionValue((Object)uRL3, (String)"URI.create(this).toURL()");
        } else if (object instanceof Provider) {
            Object object2 = ((Provider)$this$convertToUrl).get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.get()");
            uRL = UtilsKt.convertToUrl(object2);
        } else {
            throw (Throwable)new PaperweightException("Unknown URL type: " + $this$convertToUrl.getClass().getName());
        }
        return uRL;
    }

    public static final void ensureParentExists(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        for (Object file : files) {
            Path parent = UtilsKt.convertToPath(file).getParent();
            try {
                Path path;
                Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            }
            catch (Exception e) {
                throw (Throwable)new PaperweightException("Failed to create directory " + parent, e);
            }
        }
    }

    public static final void ensureDeleted(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        for (Object file : files) {
            Path f = UtilsKt.convertToPath(file);
            try {
                FileKt.deleteRecursively$default(f, null, 1, null);
            }
            catch (Exception e) {
                throw (Throwable)new PaperweightException("Failed to delete file " + f, e);
            }
        }
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput, @NotNull String name2, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"$this$defaultOutput");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        RegularFileProperty regularFileProperty = $this$defaultOutput.getObjects().fileProperty().convention(new RegularFile($this$defaultOutput, name2, ext){
            final /* synthetic */ BaseTask $this_defaultOutput;
            final /* synthetic */ String $name;
            final /* synthetic */ String $ext;

            @NotNull
            public final File getAsFile() {
                return UtilsKt.getCache(this.$this_defaultOutput.getLayout()).resolve(ConstantsKt.paperTaskOutput(this.$name, this.$ext)).toFile();
            }
            {
                this.$this_defaultOutput = baseTask;
                this.$name = string;
                this.$ext = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty().c\u2026ame, ext)).toFile()\n    }");
        return regularFileProperty;
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"$this$defaultOutput");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        String string = $this$defaultOutput.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return UtilsKt.defaultOutput($this$defaultOutput, string, ext);
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"$this$defaultOutput");
        return UtilsKt.defaultOutput($this$defaultOutput, "jar");
    }

    @Nullable
    public static final <T> T getOrNull(@NotNull Optional<T> $this$orNull) {
        Intrinsics.checkNotNullParameter($this$orNull, (String)"$this$orNull");
        return $this$orNull.orElse(null);
    }

    public static final /* synthetic */ <T> Provider<T> contents(Project $this$contents, RegularFileProperty contentFile, Function1<? super String, ? extends T> convert) {
        int $i$f$contents = 0;
        Intrinsics.checkNotNullParameter((Object)$this$contents, (String)"$this$contents");
        Intrinsics.checkNotNullParameter((Object)contentFile, (String)"contentFile");
        Intrinsics.checkNotNullParameter(convert, (String)"convert");
        FileContents fileContents = $this$contents.getProviders().fileContents((Provider)contentFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileContents, (String)"providers.fileContents(contentFile)");
        Provider provider = fileContents.getAsText().forUseAtConfigurationTime().map(new Transformer(convert){
            final /* synthetic */ Function1 $convert;

            @NotNull
            public final T transform(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)this.$convert.invoke((Object)it);
            }
            {
                this.$convert = function1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.fileContents(c\u2026     .map { convert(it) }");
        return provider;
    }

    @NotNull
    public static final Path findOutputDir(@NotNull Path baseFile) {
        LinkOption[] linkOptionArray;
        Path path;
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Path dir = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)baseFile.resolveSibling(PathsKt.getName((Path)baseFile) + '-' + ThreadLocalRandom.current().nextInt()), (String)"baseFile.resolveSibling(\u2026ndom.current().nextInt())");
            path = dir;
            linkOptionArray = new LinkOption[]{};
            boolean bl = false;
        } while (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        return dir;
    }

    @NotNull
    public static final <T> MergeResult<T> emptyMergeResult() {
        MergeResult mergeResult = emptyMergeResult;
        if (mergeResult == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.cadixdev.lorenz.merge.MergeResult<T?>");
        }
        return mergeResult;
    }

    public static final /* synthetic */ <T extends Task> RegisteringDomainObjectDelegateProviderWithTypeAndAction<? extends TaskContainer, T> registering(TaskContainer $this$registering, Function1<? super T, Unit> configuration) {
        int $i$f$registering = 0;
        Intrinsics.checkNotNullParameter((Object)$this$registering, (String)"$this$registering");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)$this$registering;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return NamedDomainObjectContainerExtensionsKt.registering((PolymorphicDomainObjectContainer)polymorphicDomainObjectContainer, (KClass)Reflection.getOrCreateKotlinClass(Task.class), configuration);
    }

    public static final /* synthetic */ <T extends Task> RegisteringDomainObjectDelegateProviderWithType<? extends TaskContainer, T> registering(TaskContainer $this$registering) {
        int $i$f$registering = 0;
        Intrinsics.checkNotNullParameter((Object)$this$registering, (String)"$this$registering");
        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)$this$registering;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return NamedDomainObjectContainerExtensionsKt.registering((PolymorphicDomainObjectContainer)polymorphicDomainObjectContainer, (KClass)Reflection.getOrCreateKotlinClass(Task.class));
    }

    @NotNull
    public static final MessageDigest getDigestSha256() {
        MessageDigest messageDigest = threadLocalDigestSha256.get();
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"threadLocalDigestSha256.get()");
        return messageDigest;
    }

    @NotNull
    public static final String toHex(@NotNull byte[] hash2) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        StringBuilder sb = new StringBuilder(hash2.length * 2);
        for (byte aHash : hash2) {
            String string = "%02x";
            Object[] objectArray = new Object[]{aHash & 0xFF};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
            sb.append(string2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final Provider<JavaLauncher> defaultJavaLauncher(@NotNull JavaToolchainService $this$defaultJavaLauncher, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultJavaLauncher, (String)"$this$defaultJavaLauncher");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $this$getByType$iv = extensionContainer;
        boolean $i$f$getByType = false;
        boolean $i$f$typeOf = false;
        Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
        Provider provider = $this$defaultJavaLauncher.launcherFor(((JavaPluginExtension)object).getToolchain()).orElse($this$defaultJavaLauncher.launcherFor((Action)defaultJavaLauncher.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"launcherFor(project.exte\u2026n.of(17))\n        }\n    )");
        return provider;
    }

    @NotNull
    public static final <P extends Property<?>> P withDisallowChanges(@NotNull P $this$withDisallowChanges) {
        Intrinsics.checkNotNullParameter($this$withDisallowChanges, (String)"$this$withDisallowChanges");
        P p = $this$withDisallowChanges;
        boolean bl = false;
        boolean bl2 = false;
        P $this$apply = p;
        boolean bl3 = false;
        $this$apply.disallowChanges();
        return p;
    }

    @NotNull
    public static final <P extends Property<?>> P withDisallowUnsafeRead(@NotNull P $this$withDisallowUnsafeRead) {
        Intrinsics.checkNotNullParameter($this$withDisallowUnsafeRead, (String)"$this$withDisallowUnsafeRead");
        P p = $this$withDisallowUnsafeRead;
        boolean bl = false;
        boolean bl2 = false;
        P $this$apply = p;
        boolean bl3 = false;
        $this$apply.disallowUnsafeRead();
        return p;
    }

    @NotNull
    public static final List<ClassProviderRoot> toJarClassProviderRoots(@NotNull FileCollection $this$toJarClassProviderRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$toJarClassProviderRoots, (String)"$this$toJarClassProviderRoots");
        Set set = $this$toJarClassProviderRoots.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)toJarClassProviderRoots.1.INSTANCE), (Function1)toJarClassProviderRoots.2.INSTANCE), (Function1)toJarClassProviderRoots.3.INSTANCE));
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, new PathJsonConverter()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().disableHtm\u2026JsonConverter()).create()");
        UtilsKt.gson = gson;
        emptyMergeResult = new MergeResult<Object>(null);
        ThreadLocal threadLocal = ThreadLocal.withInitial(threadLocalDigestSha256.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"ThreadLocal.withInitial \u2026.getInstance(\"SHA-256\")\n}");
        threadLocalDigestSha256 = threadLocal;
    }
}

