/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UselessOutputStream;
import io.papermc.paperweight.util.UtilsKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B#\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f\"\u00020\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/papermc/paperweight/util/Git;", "", "repo", "(Ljava/lang/Object;)V", "Ljava/nio/file/Path;", "env", "", "", "(Ljava/nio/file/Path;Ljava/util/Map;)V", "invoke", "Lio/papermc/paperweight/util/Command;", "args", "", "([Ljava/lang/String;)Lio/papermc/paperweight/util/Command;", "withEnv", "Companion", "paperweight-lib"})
public final class Git {
    private final Path repo;
    private final Map<String, String> env;
    private static final String IGNORE_GITIGNORE_PROPERTY_NAME = "paperweight.ignore-gitignore";
    @Nullable
    private static Provider<Boolean> ignorePropertyField;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Git withEnv(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        return new Git(this.repo, env);
    }

    @NotNull
    public final Command invoke(String ... args) {
        Command command;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)"git");
        spreadBuilder.add((Object)"-c");
        spreadBuilder.add((Object)"commit.gpgsign=false");
        spreadBuilder.add((Object)"-c");
        spreadBuilder.add((Object)"core.safecrlf=false");
        spreadBuilder.addSpread((Object)args);
        Object[] cmd = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
        try {
            ProcessBuilder builder = FileKt.directory(new ProcessBuilder(Arrays.copyOf(cmd, cmd.length)), this.repo);
            builder.environment().putAll(this.env);
            List<String> list = builder.command();
            Intrinsics.checkNotNullExpressionValue(list, (String)"builder.command()");
            String commandText2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, (Function1)invoke.commandText.1.INSTANCE, (int)30, null);
            command = new Command(builder, commandText2);
        }
        catch (IOException e) {
            throw (Throwable)new PaperweightException("Failed to execute command: " + ArraysKt.joinToString$default((Object[])cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), e);
        }
        return command;
    }

    public Git(@NotNull Path repo, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        this.repo = repo;
        this.env = env;
        Path path = this.repo;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw (Throwable)new PaperweightException("Git directory does not exist: " + this.repo);
        }
    }

    public /* synthetic */ Git(Path path, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(path, map2);
    }

    public Git(@NotNull Object repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        this(UtilsKt.convertToPath(repo), null, 2, null);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\r\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lio/papermc/paperweight/util/Git$Companion;", "", "()V", "IGNORE_GITIGNORE_PROPERTY_NAME", "", "ignorePropertyField", "Lorg/gradle/api/provider/Provider;", "", "getIgnorePropertyField", "()Lorg/gradle/api/provider/Provider;", "setIgnorePropertyField", "(Lorg/gradle/api/provider/Provider;)V", "add", "", "ignoreGitIgnore", "args", "(Z[Ljava/lang/String;)[Ljava/lang/String;", "(Lorg/gradle/api/provider/Provider;[Ljava/lang/String;)[Ljava/lang/String;", "checkForGit", "", "ignoreProperty", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "paperweight-lib"})
    public static final class Companion {
        @Nullable
        public final Provider<Boolean> getIgnorePropertyField() {
            return ignorePropertyField;
        }

        public final void setIgnorePropertyField(@Nullable Provider<Boolean> provider) {
            ignorePropertyField = provider;
        }

        @NotNull
        public final Provider<Boolean> ignoreProperty(@NotNull ProviderFactory providers) {
            Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
            Provider current = this.getIgnorePropertyField();
            if (current != null) {
                return current;
            }
            current = providers.gradleProperty(Git.IGNORE_GITIGNORE_PROPERTY_NAME).map((Transformer)ignoreProperty.1.INSTANCE).orElse((Object)false);
            this.setIgnorePropertyField((Provider<Boolean>)current);
            return current;
        }

        @NotNull
        public final String[] add(@NotNull Provider<Boolean> ignoreGitIgnore, String ... args) {
            Intrinsics.checkNotNullParameter(ignoreGitIgnore, (String)"ignoreGitIgnore");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Object object = ignoreGitIgnore.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoreGitIgnore.get()");
            return this.add((Boolean)object, Arrays.copyOf(args, args.length));
        }

        @NotNull
        public final String[] add(boolean ignoreGitIgnore, String ... args) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (ignoreGitIgnore) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                spreadBuilder.add((Object)"add");
                spreadBuilder.add((Object)"--force");
                spreadBuilder.addSpread((Object)args);
                stringArray = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
            } else {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)"add");
                spreadBuilder.addSpread((Object)args);
                stringArray = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
            }
            return stringArray;
        }

        public final void checkForGit() {
            try {
                Process proc;
                Process process = proc = new ProcessBuilder("git", "--version").redirectErrorStream(true).start();
                Intrinsics.checkNotNullExpressionValue((Object)process, (String)"proc");
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"proc.inputStream");
                ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)UselessOutputStream.INSTANCE, (int)0, (int)2, null);
                if (proc.waitFor() == 0) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (Throwable)new PaperweightException("You must have git installed and available on your PATH in order to use paperweight.");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

